package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import me.snowdrop.istio.api.BoolValue;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import me.snowdrop.istio.api.BoolValueBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import me.snowdrop.istio.api.BoolValueFluentImpl;
import me.snowdrop.istio.api.DurationBuilder;

public class CorsPolicyFluentImpl<A extends CorsPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CorsPolicyFluent<A>{

    private BoolValueBuilder allowCredentials;
    private List<String> allowHeaders;
    private List<String> allowMethods;
    private List<String> allowOrigin;
    private List<String> exposeHeaders;
    private DurationBuilder maxAge;

    public CorsPolicyFluentImpl(){
    }
    public CorsPolicyFluentImpl(CorsPolicy instance){
            this.withAllowCredentials(instance.getAllowCredentials()); 
            this.withAllowHeaders(instance.getAllowHeaders()); 
            this.withAllowMethods(instance.getAllowMethods()); 
            this.withAllowOrigin(instance.getAllowOrigin()); 
            this.withExposeHeaders(instance.getExposeHeaders()); 
            this.withMaxAge(instance.getMaxAge()); 
    }

    
/**
 * This method has been deprecated, please use method buildAllowCredentials instead.
 * @return The buildable object.
 */
@Deprecated public BoolValue getAllowCredentials(){
            return this.allowCredentials!=null?this.allowCredentials.build():null;
    }

    public BoolValue buildAllowCredentials(){
            return this.allowCredentials!=null?this.allowCredentials.build():null;
    }

    public A withAllowCredentials(BoolValue allowCredentials){
            _visitables.remove(this.allowCredentials);
            if (allowCredentials!=null){ this.allowCredentials= new BoolValueBuilder(allowCredentials); _visitables.add(this.allowCredentials);} return (A) this;
    }

    public Boolean hasAllowCredentials(){
            return this.allowCredentials != null;
    }

    public A withNewAllowCredentials(Boolean value){
            return (A)withAllowCredentials(new BoolValue(value));
    }

    public CorsPolicyFluent.AllowCredentialsNested<A> withNewAllowCredentials(){
            return new AllowCredentialsNestedImpl();
    }

    public CorsPolicyFluent.AllowCredentialsNested<A> withNewAllowCredentialsLike(BoolValue item){
            return new AllowCredentialsNestedImpl(item);
    }

    public CorsPolicyFluent.AllowCredentialsNested<A> editAllowCredentials(){
            return withNewAllowCredentialsLike(getAllowCredentials());
    }

    public CorsPolicyFluent.AllowCredentialsNested<A> editOrNewAllowCredentials(){
            return withNewAllowCredentialsLike(getAllowCredentials() != null ? getAllowCredentials(): new BoolValueBuilder().build());
    }

    public CorsPolicyFluent.AllowCredentialsNested<A> editOrNewAllowCredentialsLike(BoolValue item){
            return withNewAllowCredentialsLike(getAllowCredentials() != null ? getAllowCredentials(): item);
    }

    public A addToAllowHeaders(int index,String item){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            this.allowHeaders.add(index, item);
            return (A)this;
    }

    public A setToAllowHeaders(int index,String item){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            this.allowHeaders.set(index, item); return (A)this;
    }

    public A addToAllowHeaders(String... items){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            for (String item : items) {this.allowHeaders.add(item);} return (A)this;
    }

    public A addAllToAllowHeaders(Collection<String> items){
            if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
            for (String item : items) {this.allowHeaders.add(item);} return (A)this;
    }

    public A removeFromAllowHeaders(String... items){
            for (String item : items) {if (this.allowHeaders!= null){ this.allowHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowHeaders(Collection<String> items){
            for (String item : items) {if (this.allowHeaders!= null){ this.allowHeaders.remove(item);}} return (A)this;
    }

    public List<String> getAllowHeaders(){
            return this.allowHeaders;
    }

    public String getAllowHeader(int index){
            return this.allowHeaders.get(index);
    }

    public String getFirstAllowHeader(){
            return this.allowHeaders.get(0);
    }

    public String getLastAllowHeader(){
            return this.allowHeaders.get(allowHeaders.size() - 1);
    }

    public String getMatchingAllowHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowHeaders) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAllowHeaders(List<String> allowHeaders){
            if (this.allowHeaders != null) { _visitables.removeAll(this.allowHeaders);}
            if (allowHeaders != null) {this.allowHeaders = new ArrayList<String>(); for (String item : allowHeaders){this.addToAllowHeaders(item);}} else { this.allowHeaders = null;} return (A) this;
    }

    public A withAllowHeaders(String... allowHeaders){
            if (this.allowHeaders != null) {this.allowHeaders.clear();}
            if (allowHeaders != null) {for (String item :allowHeaders){ this.addToAllowHeaders(item);}} return (A) this;
    }

    public Boolean hasAllowHeaders(){
            return allowHeaders != null && !allowHeaders.isEmpty();
    }

    public A addToAllowMethods(int index,String item){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            this.allowMethods.add(index, item);
            return (A)this;
    }

    public A setToAllowMethods(int index,String item){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            this.allowMethods.set(index, item); return (A)this;
    }

    public A addToAllowMethods(String... items){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            for (String item : items) {this.allowMethods.add(item);} return (A)this;
    }

    public A addAllToAllowMethods(Collection<String> items){
            if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
            for (String item : items) {this.allowMethods.add(item);} return (A)this;
    }

    public A removeFromAllowMethods(String... items){
            for (String item : items) {if (this.allowMethods!= null){ this.allowMethods.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowMethods(Collection<String> items){
            for (String item : items) {if (this.allowMethods!= null){ this.allowMethods.remove(item);}} return (A)this;
    }

    public List<String> getAllowMethods(){
            return this.allowMethods;
    }

    public String getAllowMethod(int index){
            return this.allowMethods.get(index);
    }

    public String getFirstAllowMethod(){
            return this.allowMethods.get(0);
    }

    public String getLastAllowMethod(){
            return this.allowMethods.get(allowMethods.size() - 1);
    }

    public String getMatchingAllowMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowMethods) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAllowMethods(List<String> allowMethods){
            if (this.allowMethods != null) { _visitables.removeAll(this.allowMethods);}
            if (allowMethods != null) {this.allowMethods = new ArrayList<String>(); for (String item : allowMethods){this.addToAllowMethods(item);}} else { this.allowMethods = null;} return (A) this;
    }

    public A withAllowMethods(String... allowMethods){
            if (this.allowMethods != null) {this.allowMethods.clear();}
            if (allowMethods != null) {for (String item :allowMethods){ this.addToAllowMethods(item);}} return (A) this;
    }

    public Boolean hasAllowMethods(){
            return allowMethods != null && !allowMethods.isEmpty();
    }

    public A addToAllowOrigin(int index,String item){
            if (this.allowOrigin == null) {this.allowOrigin = new ArrayList<String>();}
            this.allowOrigin.add(index, item);
            return (A)this;
    }

    public A setToAllowOrigin(int index,String item){
            if (this.allowOrigin == null) {this.allowOrigin = new ArrayList<String>();}
            this.allowOrigin.set(index, item); return (A)this;
    }

    public A addToAllowOrigin(String... items){
            if (this.allowOrigin == null) {this.allowOrigin = new ArrayList<String>();}
            for (String item : items) {this.allowOrigin.add(item);} return (A)this;
    }

    public A addAllToAllowOrigin(Collection<String> items){
            if (this.allowOrigin == null) {this.allowOrigin = new ArrayList<String>();}
            for (String item : items) {this.allowOrigin.add(item);} return (A)this;
    }

    public A removeFromAllowOrigin(String... items){
            for (String item : items) {if (this.allowOrigin!= null){ this.allowOrigin.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowOrigin(Collection<String> items){
            for (String item : items) {if (this.allowOrigin!= null){ this.allowOrigin.remove(item);}} return (A)this;
    }

    public List<String> getAllowOrigin(){
            return this.allowOrigin;
    }

    public String getAllowOrigin(int index){
            return this.allowOrigin.get(index);
    }

    public String getFirstAllowOrigin(){
            return this.allowOrigin.get(0);
    }

    public String getLastAllowOrigin(){
            return this.allowOrigin.get(allowOrigin.size() - 1);
    }

    public String getMatchingAllowOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowOrigin) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAllowOrigin(List<String> allowOrigin){
            if (this.allowOrigin != null) { _visitables.removeAll(this.allowOrigin);}
            if (allowOrigin != null) {this.allowOrigin = new ArrayList<String>(); for (String item : allowOrigin){this.addToAllowOrigin(item);}} else { this.allowOrigin = null;} return (A) this;
    }

    public A withAllowOrigin(String... allowOrigin){
            if (this.allowOrigin != null) {this.allowOrigin.clear();}
            if (allowOrigin != null) {for (String item :allowOrigin){ this.addToAllowOrigin(item);}} return (A) this;
    }

    public Boolean hasAllowOrigin(){
            return allowOrigin != null && !allowOrigin.isEmpty();
    }

    public A addToExposeHeaders(int index,String item){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            this.exposeHeaders.add(index, item);
            return (A)this;
    }

    public A setToExposeHeaders(int index,String item){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            this.exposeHeaders.set(index, item); return (A)this;
    }

    public A addToExposeHeaders(String... items){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            for (String item : items) {this.exposeHeaders.add(item);} return (A)this;
    }

    public A addAllToExposeHeaders(Collection<String> items){
            if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
            for (String item : items) {this.exposeHeaders.add(item);} return (A)this;
    }

    public A removeFromExposeHeaders(String... items){
            for (String item : items) {if (this.exposeHeaders!= null){ this.exposeHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromExposeHeaders(Collection<String> items){
            for (String item : items) {if (this.exposeHeaders!= null){ this.exposeHeaders.remove(item);}} return (A)this;
    }

    public List<String> getExposeHeaders(){
            return this.exposeHeaders;
    }

    public String getExposeHeader(int index){
            return this.exposeHeaders.get(index);
    }

    public String getFirstExposeHeader(){
            return this.exposeHeaders.get(0);
    }

    public String getLastExposeHeader(){
            return this.exposeHeaders.get(exposeHeaders.size() - 1);
    }

    public String getMatchingExposeHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exposeHeaders) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withExposeHeaders(List<String> exposeHeaders){
            if (this.exposeHeaders != null) { _visitables.removeAll(this.exposeHeaders);}
            if (exposeHeaders != null) {this.exposeHeaders = new ArrayList<String>(); for (String item : exposeHeaders){this.addToExposeHeaders(item);}} else { this.exposeHeaders = null;} return (A) this;
    }

    public A withExposeHeaders(String... exposeHeaders){
            if (this.exposeHeaders != null) {this.exposeHeaders.clear();}
            if (exposeHeaders != null) {for (String item :exposeHeaders){ this.addToExposeHeaders(item);}} return (A) this;
    }

    public Boolean hasExposeHeaders(){
            return exposeHeaders != null && !exposeHeaders.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildMaxAge instead.
 * @return The buildable object.
 */
@Deprecated public Duration getMaxAge(){
            return this.maxAge!=null?this.maxAge.build():null;
    }

    public Duration buildMaxAge(){
            return this.maxAge!=null?this.maxAge.build():null;
    }

    public A withMaxAge(Duration maxAge){
            _visitables.remove(this.maxAge);
            if (maxAge!=null){ this.maxAge= new DurationBuilder(maxAge); _visitables.add(this.maxAge);} return (A) this;
    }

    public Boolean hasMaxAge(){
            return this.maxAge != null;
    }

    public A withNewMaxAge(Integer nanos,Long seconds){
            return (A)withMaxAge(new Duration(nanos, seconds));
    }

    public CorsPolicyFluent.MaxAgeNested<A> withNewMaxAge(){
            return new MaxAgeNestedImpl();
    }

    public CorsPolicyFluent.MaxAgeNested<A> withNewMaxAgeLike(Duration item){
            return new MaxAgeNestedImpl(item);
    }

    public CorsPolicyFluent.MaxAgeNested<A> editMaxAge(){
            return withNewMaxAgeLike(getMaxAge());
    }

    public CorsPolicyFluent.MaxAgeNested<A> editOrNewMaxAge(){
            return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): new DurationBuilder().build());
    }

    public CorsPolicyFluent.MaxAgeNested<A> editOrNewMaxAgeLike(Duration item){
            return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CorsPolicyFluentImpl that = (CorsPolicyFluentImpl) o;
            if (allowCredentials != null ? !allowCredentials.equals(that.allowCredentials) :that.allowCredentials != null) return false;
            if (allowHeaders != null ? !allowHeaders.equals(that.allowHeaders) :that.allowHeaders != null) return false;
            if (allowMethods != null ? !allowMethods.equals(that.allowMethods) :that.allowMethods != null) return false;
            if (allowOrigin != null ? !allowOrigin.equals(that.allowOrigin) :that.allowOrigin != null) return false;
            if (exposeHeaders != null ? !exposeHeaders.equals(that.exposeHeaders) :that.exposeHeaders != null) return false;
            if (maxAge != null ? !maxAge.equals(that.maxAge) :that.maxAge != null) return false;
            return true;
    }


    public class AllowCredentialsNestedImpl<N> extends BoolValueFluentImpl<CorsPolicyFluent.AllowCredentialsNested<N>> implements CorsPolicyFluent.AllowCredentialsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BoolValueBuilder builder;
    
            AllowCredentialsNestedImpl(BoolValue item){
                    this.builder = new BoolValueBuilder(this, item);
            }
            AllowCredentialsNestedImpl(){
                    this.builder = new BoolValueBuilder(this);
            }
    
    public N and(){
            return (N) CorsPolicyFluentImpl.this.withAllowCredentials(builder.build());
    }
    public N endAllowCredentials(){
            return and();
    }

}
    public class MaxAgeNestedImpl<N> extends DurationFluentImpl<CorsPolicyFluent.MaxAgeNested<N>> implements CorsPolicyFluent.MaxAgeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            MaxAgeNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            MaxAgeNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) CorsPolicyFluentImpl.this.withMaxAge(builder.build());
    }
    public N endMaxAge(){
            return and();
    }

}


}
