package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class AbortFluentImpl<A extends AbortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AbortFluent<A>{

    private VisitableBuilder<? extends me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType,?> errorType;
    private Integer percent;

    public AbortFluentImpl(){
    }
    public AbortFluentImpl(Abort instance){
            this.withErrorType(instance.getErrorType()); 
            this.withPercent(instance.getPercent()); 
    }

    
/**
 * This method has been deprecated, please use method buildErrorType instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType getErrorType(){
            return this.errorType!=null?this.errorType.build():null;
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType buildErrorType(){
            return this.errorType!=null?this.errorType.build():null;
    }

    public A withErrorType(me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType){
            if (errorType instanceof HttpStatusErrorType){ this.errorType= new HttpStatusErrorTypeBuilder((HttpStatusErrorType)errorType); _visitables.add(this.errorType);}
            if (errorType instanceof GrpcStatusErrorType){ this.errorType= new GrpcStatusErrorTypeBuilder((GrpcStatusErrorType)errorType); _visitables.add(this.errorType);}
            if (errorType instanceof Http2ErrorErrorType){ this.errorType= new Http2ErrorErrorTypeBuilder((Http2ErrorErrorType)errorType); _visitables.add(this.errorType);}
            return (A) this;
    }

    public Boolean hasErrorType(){
            return this.errorType != null;
    }

    public A withHttpStatusErrorType(HttpStatusErrorType httpStatusErrorType){
            _visitables.remove(this.errorType);
            if (httpStatusErrorType!=null){ this.errorType= new HttpStatusErrorTypeBuilder(httpStatusErrorType); _visitables.add(this.errorType);} return (A) this;
    }

    public AbortFluent.HttpStatusErrorTypeNested<A> withNewHttpStatusErrorType(){
            return new HttpStatusErrorTypeNestedImpl();
    }

    public AbortFluent.HttpStatusErrorTypeNested<A> withNewHttpStatusErrorTypeLike(HttpStatusErrorType item){
            return new HttpStatusErrorTypeNestedImpl(item);
    }

    public A withNewHttpStatusErrorType(Integer httpStatus){
            return (A)withHttpStatusErrorType(new HttpStatusErrorType(httpStatus));
    }

    public A withGrpcStatusErrorType(GrpcStatusErrorType grpcStatusErrorType){
            _visitables.remove(this.errorType);
            if (grpcStatusErrorType!=null){ this.errorType= new GrpcStatusErrorTypeBuilder(grpcStatusErrorType); _visitables.add(this.errorType);} return (A) this;
    }

    public AbortFluent.GrpcStatusErrorTypeNested<A> withNewGrpcStatusErrorType(){
            return new GrpcStatusErrorTypeNestedImpl();
    }

    public AbortFluent.GrpcStatusErrorTypeNested<A> withNewGrpcStatusErrorTypeLike(GrpcStatusErrorType item){
            return new GrpcStatusErrorTypeNestedImpl(item);
    }

    public A withNewGrpcStatusErrorType(String grpcStatus){
            return (A)withGrpcStatusErrorType(new GrpcStatusErrorType(grpcStatus));
    }

    public A withHttp2ErrorType(Http2ErrorErrorType http2ErrorType){
            _visitables.remove(this.errorType);
            if (http2ErrorType!=null){ this.errorType= new Http2ErrorErrorTypeBuilder(http2ErrorType); _visitables.add(this.errorType);} return (A) this;
    }

    public AbortFluent.Http2ErrorTypeNested<A> withNewHttp2ErrorType(){
            return new Http2ErrorTypeNestedImpl();
    }

    public AbortFluent.Http2ErrorTypeNested<A> withNewHttp2ErrorTypeLike(Http2ErrorErrorType item){
            return new Http2ErrorTypeNestedImpl(item);
    }

    public A withNewHttp2ErrorType(String http2Error){
            return (A)withHttp2ErrorType(new Http2ErrorErrorType(http2Error));
    }

    public Integer getPercent(){
            return this.percent;
    }

    public A withPercent(Integer percent){
            this.percent=percent; return (A) this;
    }

    public Boolean hasPercent(){
            return this.percent != null;
    }

    public A withNewPercent(String arg1){
            return (A)withPercent(new Integer(arg1));
    }

    public A withNewPercent(int arg1){
            return (A)withPercent(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AbortFluentImpl that = (AbortFluentImpl) o;
            if (errorType != null ? !errorType.equals(that.errorType) :that.errorType != null) return false;
            if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
            return true;
    }


    public class HttpStatusErrorTypeNestedImpl<N> extends HttpStatusErrorTypeFluentImpl<AbortFluent.HttpStatusErrorTypeNested<N>> implements AbortFluent.HttpStatusErrorTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HttpStatusErrorTypeBuilder builder;
    
            HttpStatusErrorTypeNestedImpl(HttpStatusErrorType item){
                    this.builder = new HttpStatusErrorTypeBuilder(this, item);
            }
            HttpStatusErrorTypeNestedImpl(){
                    this.builder = new HttpStatusErrorTypeBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withHttpStatusErrorType(builder.build());
    }
    public N endHttpStatusErrorType(){
            return and();
    }

}
    public class GrpcStatusErrorTypeNestedImpl<N> extends GrpcStatusErrorTypeFluentImpl<AbortFluent.GrpcStatusErrorTypeNested<N>> implements AbortFluent.GrpcStatusErrorTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GrpcStatusErrorTypeBuilder builder;
    
            GrpcStatusErrorTypeNestedImpl(GrpcStatusErrorType item){
                    this.builder = new GrpcStatusErrorTypeBuilder(this, item);
            }
            GrpcStatusErrorTypeNestedImpl(){
                    this.builder = new GrpcStatusErrorTypeBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withGrpcStatusErrorType(builder.build());
    }
    public N endGrpcStatusErrorType(){
            return and();
    }

}
    public class Http2ErrorTypeNestedImpl<N> extends Http2ErrorErrorTypeFluentImpl<AbortFluent.Http2ErrorTypeNested<N>> implements AbortFluent.Http2ErrorTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final Http2ErrorErrorTypeBuilder builder;
    
            Http2ErrorTypeNestedImpl(Http2ErrorErrorType item){
                    this.builder = new Http2ErrorErrorTypeBuilder(this, item);
            }
            Http2ErrorTypeNestedImpl(){
                    this.builder = new Http2ErrorErrorTypeBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withHttp2ErrorType(builder.build());
    }
    public N endHttp2ErrorType(){
            return and();
    }

}


}
