package me.snowdrop.istio.api.model;

import io.fabric8.kubernetes.api.KubernetesResourceMappingProvider;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.HashMap;
import java.util.Map;

import me.snowdrop.istio.api.networking.v1alpha3.VirtualService;
import me.snowdrop.istio.mixer.adapter.servicecontrol.Servicecontrol;
import me.snowdrop.istio.mixer.template.logentry.LogEntry;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpan;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBinding;
import me.snowdrop.istio.mixer.template.apikey.ApiKey;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationRule;
import me.snowdrop.istio.mixer.adapter.opa.Opa;
import me.snowdrop.istio.mixer.adapter.rbac.Rbac;
import me.snowdrop.istio.mixer.adapter.statsd.Statsd;
import me.snowdrop.istio.mixer.adapter.prometheus.Prometheus;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothing;
import me.snowdrop.istio.mixer.template.edge.Edge;
import me.snowdrop.istio.api.rbac.v1alpha1.RbacConfig;
import me.snowdrop.istio.mixer.adapter.denier.Denier;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRole;
import me.snowdrop.istio.api.policy.v1beta1.Rule;
import me.snowdrop.istio.mixer.adapter.memquota.Memquota;
import me.snowdrop.istio.mixer.template.quota.Quota;
import me.snowdrop.istio.mixer.adapter.fluentd.Fluentd;
import me.snowdrop.istio.api.authentication.v1alpha1.Policy;
import me.snowdrop.istio.mixer.adapter.circonus.Circonus;
import me.snowdrop.istio.mixer.adapter.signalfx.Signalfx;
import me.snowdrop.istio.mixer.template.authorization.Authorization;
import me.snowdrop.istio.mixer.adapter.stdio.Stdio;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyFilter;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothing;
import me.snowdrop.istio.mixer.adapter.kubernetesenv.Kubernetesenv;
import me.snowdrop.istio.api.networking.v1alpha3.Gateway;
import me.snowdrop.istio.api.networking.v1alpha3.ServiceEntry;
import me.snowdrop.istio.mixer.template.listentry.ListEntry;
import me.snowdrop.istio.mixer.adapter.solarwinds.Solarwinds;
import me.snowdrop.istio.mixer.template.metric.Metric;
import me.snowdrop.istio.mixer.adapter.bypass.Bypass;
import me.snowdrop.istio.mixer.adapter.stackdriver.Stackdriver;
import me.snowdrop.istio.mixer.adapter.redisquota.Redisquota;

public class IstioResourceMappingsProvider implements KubernetesResourceMappingProvider {

    public final Map<String, Class<? extends KubernetesResource>> mappings = new HashMap<>();

    public IstioResourceMappingsProvider () {

        mappings.put("networking.istio.io/v1alpha3#VirtualService", VirtualService.class);
        mappings.put("config.istio.io/v1alpha2#servicecontrol", Servicecontrol.class);
        mappings.put("config.istio.io/v1alpha2#logentry", LogEntry.class);
        mappings.put("config.istio.io/v1alpha2#tracespan", TraceSpan.class);
        mappings.put("rbac.istio.io/v1alpha1#ServiceRoleBinding", ServiceRoleBinding.class);
        mappings.put("config.istio.io/v1alpha2#apikey", ApiKey.class);
        mappings.put("networking.istio.io/v1alpha3#DestinationRule", DestinationRule.class);
        mappings.put("config.istio.io/v1alpha2#opa", Opa.class);
        mappings.put("config.istio.io/v1alpha2#rbac", Rbac.class);
        mappings.put("config.istio.io/v1alpha2#statsd", Statsd.class);
        mappings.put("config.istio.io/v1alpha2#prometheus", Prometheus.class);
        mappings.put("config.istio.io/v1alpha2#reportnothing", ReportNothing.class);
        mappings.put("config.istio.io/v1alpha2#edge", Edge.class);
        mappings.put("rbac.istio.io/v1alpha1#RbacConfig", RbacConfig.class);
        mappings.put("config.istio.io/v1alpha2#denier", Denier.class);
        mappings.put("rbac.istio.io/v1alpha1#ServiceRole", ServiceRole.class);
        mappings.put("config.istio.io/v1alpha2#rule", Rule.class);
        mappings.put("config.istio.io/v1alpha2#memquota", Memquota.class);
        mappings.put("config.istio.io/v1alpha2#quota", Quota.class);
        mappings.put("config.istio.io/v1alpha2#fluentd", Fluentd.class);
        mappings.put("authentication.istio.io/v1alpha1#Policy", Policy.class);
        mappings.put("config.istio.io/v1alpha2#circonus", Circonus.class);
        mappings.put("config.istio.io/v1alpha2#signalfx", Signalfx.class);
        mappings.put("config.istio.io/v1alpha2#authorization", Authorization.class);
        mappings.put("config.istio.io/v1alpha2#stdio", Stdio.class);
        mappings.put("networking.istio.io/v1alpha3#EnvoyFilter", EnvoyFilter.class);
        mappings.put("config.istio.io/v1alpha2#checknothing", CheckNothing.class);
        mappings.put("config.istio.io/v1alpha2#kubernetesenv", Kubernetesenv.class);
        mappings.put("networking.istio.io/v1alpha3#Gateway", Gateway.class);
        mappings.put("networking.istio.io/v1alpha3#ServiceEntry", ServiceEntry.class);
        mappings.put("config.istio.io/v1alpha2#listentry", ListEntry.class);
        mappings.put("config.istio.io/v1alpha2#solarwinds", Solarwinds.class);
        mappings.put("config.istio.io/v1alpha2#metric", Metric.class);
        mappings.put("config.istio.io/v1alpha2#bypass", Bypass.class);
        mappings.put("config.istio.io/v1alpha2#stackdriver", Stackdriver.class);
        mappings.put("config.istio.io/v1alpha2#redisquota", Redisquota.class);
    }

    public Map<String, Class<? extends KubernetesResource>> getMappings() {
        return mappings;
    }
}
