
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributeMatches",
    "words"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ReferencedAttributes implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("attributeMatches")
    @JsonPropertyDescription("")
    @Valid
    private List<AttributeMatch> attributeMatches = new ArrayList<AttributeMatch>();
    /**
     * 
     * 
     */
    @JsonProperty("words")
    @JsonPropertyDescription("")
    @Valid
    private List<String> words = new ArrayList<String>();
    private final static long serialVersionUID = 1382499280985171L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReferencedAttributes() {
    }

    /**
     * 
     * @param attributeMatches
     * @param words
     */
    public ReferencedAttributes(List<AttributeMatch> attributeMatches, List<String> words) {
        super();
        this.attributeMatches = attributeMatches;
        this.words = words;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributeMatches")
    public List<AttributeMatch> getAttributeMatches() {
        return attributeMatches;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributeMatches")
    public void setAttributeMatches(List<AttributeMatch> attributeMatches) {
        this.attributeMatches = attributeMatches;
    }

    /**
     * 
     * 
     */
    @JsonProperty("words")
    public List<String> getWords() {
        return words;
    }

    /**
     * 
     * 
     */
    @JsonProperty("words")
    public void setWords(List<String> words) {
        this.words = words;
    }

}
