
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "grantedAmount",
    "referencedAttributes",
    "validDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class QuotaResult implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("grantedAmount")
    @JsonPropertyDescription("")
    private Long grantedAmount;
    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    @JsonPropertyDescription("")
    @Valid
    private ReferencedAttributes referencedAttributes;
    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Long validDuration;
    private final static long serialVersionUID = -4946548203596649577L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QuotaResult() {
    }

    /**
     * 
     * @param grantedAmount
     * @param referencedAttributes
     * @param validDuration
     */
    public QuotaResult(Long grantedAmount, ReferencedAttributes referencedAttributes, Long validDuration) {
        super();
        this.grantedAmount = grantedAmount;
        this.referencedAttributes = referencedAttributes;
        this.validDuration = validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("grantedAmount")
    public Long getGrantedAmount() {
        return grantedAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("grantedAmount")
    public void setGrantedAmount(Long grantedAmount) {
        this.grantedAmount = grantedAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    public ReferencedAttributes getReferencedAttributes() {
        return referencedAttributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    public void setReferencedAttributes(ReferencedAttributes referencedAttributes) {
        this.referencedAttributes = referencedAttributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public Long getValidDuration() {
        return validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public void setValidDuration(Long validDuration) {
        this.validDuration = validDuration;
    }

}
