
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "amount",
    "bestEffort"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class QuotaParams implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("amount")
    @JsonPropertyDescription("")
    private Long amount;
    /**
     * 
     * 
     */
    @JsonProperty("bestEffort")
    @JsonPropertyDescription("")
    private Boolean bestEffort;
    private final static long serialVersionUID = -6689128275363793174L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QuotaParams() {
    }

    /**
     * 
     * @param amount
     * @param bestEffort
     */
    public QuotaParams(Long amount, Boolean bestEffort) {
        super();
        this.amount = amount;
        this.bestEffort = bestEffort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("amount")
    public Long getAmount() {
        return amount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("amount")
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bestEffort")
    public Boolean getBestEffort() {
        return bestEffort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bestEffort")
    public void setBestEffort(Boolean bestEffort) {
        this.bestEffort = bestEffort;
    }

}
