
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Status;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "referencedAttributes",
    "routeDirective",
    "status",
    "validDuration",
    "validUseCount"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PreconditionResult implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    @JsonPropertyDescription("")
    @Valid
    private ReferencedAttributes referencedAttributes;
    /**
     * 
     * 
     */
    @JsonProperty("routeDirective")
    @JsonPropertyDescription("")
    @Valid
    private RouteDirective routeDirective;
    /**
     * 
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("")
    @Valid
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Long validDuration;
    /**
     * 
     * 
     */
    @JsonProperty("validUseCount")
    @JsonPropertyDescription("")
    private Integer validUseCount;
    private final static long serialVersionUID = 7989798202085110351L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PreconditionResult() {
    }

    /**
     * 
     * @param routeDirective
     * @param referencedAttributes
     * @param validDuration
     * @param validUseCount
     * @param status
     */
    public PreconditionResult(ReferencedAttributes referencedAttributes, RouteDirective routeDirective, Status status, Long validDuration, Integer validUseCount) {
        super();
        this.referencedAttributes = referencedAttributes;
        this.routeDirective = routeDirective;
        this.status = status;
        this.validDuration = validDuration;
        this.validUseCount = validUseCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    public ReferencedAttributes getReferencedAttributes() {
        return referencedAttributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    public void setReferencedAttributes(ReferencedAttributes referencedAttributes) {
        this.referencedAttributes = referencedAttributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("routeDirective")
    public RouteDirective getRouteDirective() {
        return routeDirective;
    }

    /**
     * 
     * 
     */
    @JsonProperty("routeDirective")
    public void setRouteDirective(RouteDirective routeDirective) {
        this.routeDirective = routeDirective;
    }

    /**
     * 
     * 
     */
    @JsonProperty("status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     */
    @JsonProperty("status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public Long getValidDuration() {
        return validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public void setValidDuration(Long validDuration) {
        this.validDuration = validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validUseCount")
    public Integer getValidUseCount() {
        return validUseCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validUseCount")
    public void setValidUseCount(Integer validUseCount) {
        this.validUseCount = validUseCount;
    }

}
