package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class CheckRequestFluentImpl<A extends CheckRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CheckRequestFluent<A>{

    private CompressedAttributesBuilder attributes;
    private String deduplicationId;
    private Integer globalWordCount;
    private Map<String,QuotaParams> quotas;

    public CheckRequestFluentImpl(){
    }
    public CheckRequestFluentImpl(CheckRequest instance){
            this.withAttributes(instance.getAttributes()); 
            this.withDeduplicationId(instance.getDeduplicationId()); 
            this.withGlobalWordCount(instance.getGlobalWordCount()); 
            this.withQuotas(instance.getQuotas()); 
    }

    
/**
 * This method has been deprecated, please use method buildAttributes instead.
 * @return The buildable object.
 */
@Deprecated public CompressedAttributes getAttributes(){
            return this.attributes!=null?this.attributes.build():null;
    }

    public CompressedAttributes buildAttributes(){
            return this.attributes!=null?this.attributes.build():null;
    }

    public A withAttributes(CompressedAttributes attributes){
            _visitables.remove(this.attributes);
            if (attributes!=null){ this.attributes= new CompressedAttributesBuilder(attributes); _visitables.add(this.attributes);} return (A) this;
    }

    public Boolean hasAttributes(){
            return this.attributes != null;
    }

    public CheckRequestFluent.AttributesNested<A> withNewAttributes(){
            return new AttributesNestedImpl();
    }

    public CheckRequestFluent.AttributesNested<A> withNewAttributesLike(CompressedAttributes item){
            return new AttributesNestedImpl(item);
    }

    public CheckRequestFluent.AttributesNested<A> editAttributes(){
            return withNewAttributesLike(getAttributes());
    }

    public CheckRequestFluent.AttributesNested<A> editOrNewAttributes(){
            return withNewAttributesLike(getAttributes() != null ? getAttributes(): new CompressedAttributesBuilder().build());
    }

    public CheckRequestFluent.AttributesNested<A> editOrNewAttributesLike(CompressedAttributes item){
            return withNewAttributesLike(getAttributes() != null ? getAttributes(): item);
    }

    public String getDeduplicationId(){
            return this.deduplicationId;
    }

    public A withDeduplicationId(String deduplicationId){
            this.deduplicationId=deduplicationId; return (A) this;
    }

    public Boolean hasDeduplicationId(){
            return this.deduplicationId != null;
    }

    public Integer getGlobalWordCount(){
            return this.globalWordCount;
    }

    public A withGlobalWordCount(Integer globalWordCount){
            this.globalWordCount=globalWordCount; return (A) this;
    }

    public Boolean hasGlobalWordCount(){
            return this.globalWordCount != null;
    }

    public A withNewGlobalWordCount(String arg1){
            return (A)withGlobalWordCount(new Integer(arg1));
    }

    public A withNewGlobalWordCount(int arg1){
            return (A)withGlobalWordCount(new Integer(arg1));
    }

    public A addToQuotas(String key,QuotaParams value){
            if(this.quotas == null && key != null && value != null) { this.quotas = new LinkedHashMap<String,QuotaParams>(); }
            if(key != null && value != null) {this.quotas.put(key, value);} return (A)this;
    }

    public A addToQuotas(Map<String,QuotaParams> map){
            if(this.quotas == null && map != null) { this.quotas = new LinkedHashMap<String,QuotaParams>(); }
            if(map != null) { this.quotas.putAll(map);} return (A)this;
    }

    public A removeFromQuotas(String key){
            if(this.quotas == null) { return (A) this; }
            if(key != null && this.quotas != null) {this.quotas.remove(key);} return (A)this;
    }

    public A removeFromQuotas(Map<String,QuotaParams> map){
            if(this.quotas == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.quotas != null){this.quotas.remove(key);}}} return (A)this;
    }

    public Map<String,QuotaParams> getQuotas(){
            return this.quotas;
    }

    public A withQuotas(Map<String,QuotaParams> quotas){
            if (quotas == null) { this.quotas =  null;} else {this.quotas = new LinkedHashMap<String,QuotaParams>(quotas);} return (A) this;
    }

    public Boolean hasQuotas(){
            return this.quotas != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckRequestFluentImpl that = (CheckRequestFluentImpl) o;
            if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
            if (deduplicationId != null ? !deduplicationId.equals(that.deduplicationId) :that.deduplicationId != null) return false;
            if (globalWordCount != null ? !globalWordCount.equals(that.globalWordCount) :that.globalWordCount != null) return false;
            if (quotas != null ? !quotas.equals(that.quotas) :that.quotas != null) return false;
            return true;
    }


    public class AttributesNestedImpl<N> extends CompressedAttributesFluentImpl<CheckRequestFluent.AttributesNested<N>> implements CheckRequestFluent.AttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CompressedAttributesBuilder builder;
    
            AttributesNestedImpl(CompressedAttributes item){
                    this.builder = new CompressedAttributesBuilder(this, item);
            }
            AttributesNestedImpl(){
                    this.builder = new CompressedAttributesBuilder(this);
            }
    
    public N and(){
            return (N) CheckRequestFluentImpl.this.withAttributes(builder.build());
    }
    public N endAttributes(){
            return and();
    }

}


}
