package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ProxyConfigBuilder extends ProxyConfigFluentImpl<ProxyConfigBuilder> implements VisitableBuilder<ProxyConfig,ProxyConfigBuilder>{

    ProxyConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ProxyConfigBuilder(){
            this(true);
    }
    public ProxyConfigBuilder(Boolean validationEnabled){
            this(new ProxyConfig(), validationEnabled);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ProxyConfig(), validationEnabled);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance){
            this(fluent, instance, true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailabilityZone(instance.getAvailabilityZone()); 
            fluent.withBinaryPath(instance.getBinaryPath()); 
            fluent.withConcurrency(instance.getConcurrency()); 
            fluent.withConfigPath(instance.getConfigPath()); 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            fluent.withCustomConfigFile(instance.getCustomConfigFile()); 
            fluent.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            fluent.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            fluent.withDrainDuration(instance.getDrainDuration()); 
            fluent.withInterceptionMode(instance.getInterceptionMode()); 
            fluent.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            fluent.withProxyAdminPort(instance.getProxyAdminPort()); 
            fluent.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            fluent.withServiceCluster(instance.getServiceCluster()); 
            fluent.withStatNameLength(instance.getStatNameLength()); 
            fluent.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            fluent.withZipkinAddress(instance.getZipkinAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public ProxyConfigBuilder(ProxyConfig instance){
            this(instance,true);
    }
    public ProxyConfigBuilder(ProxyConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailabilityZone(instance.getAvailabilityZone()); 
            this.withBinaryPath(instance.getBinaryPath()); 
            this.withConcurrency(instance.getConcurrency()); 
            this.withConfigPath(instance.getConfigPath()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            this.withCustomConfigFile(instance.getCustomConfigFile()); 
            this.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            this.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            this.withDrainDuration(instance.getDrainDuration()); 
            this.withInterceptionMode(instance.getInterceptionMode()); 
            this.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            this.withProxyAdminPort(instance.getProxyAdminPort()); 
            this.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            this.withServiceCluster(instance.getServiceCluster()); 
            this.withStatNameLength(instance.getStatNameLength()); 
            this.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            this.withZipkinAddress(instance.getZipkinAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public ProxyConfigBuilder(Validator validator){
            this(new ProxyConfig(), true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAvailabilityZone(instance.getAvailabilityZone()); 
            fluent.withBinaryPath(instance.getBinaryPath()); 
            fluent.withConcurrency(instance.getConcurrency()); 
            fluent.withConfigPath(instance.getConfigPath()); 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            fluent.withCustomConfigFile(instance.getCustomConfigFile()); 
            fluent.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            fluent.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            fluent.withDrainDuration(instance.getDrainDuration()); 
            fluent.withInterceptionMode(instance.getInterceptionMode()); 
            fluent.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            fluent.withProxyAdminPort(instance.getProxyAdminPort()); 
            fluent.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            fluent.withServiceCluster(instance.getServiceCluster()); 
            fluent.withStatNameLength(instance.getStatNameLength()); 
            fluent.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            fluent.withZipkinAddress(instance.getZipkinAddress()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ProxyConfigBuilder(ProxyConfig instance,Validator validator){
            this.fluent = this; 
            this.withAvailabilityZone(instance.getAvailabilityZone()); 
            this.withBinaryPath(instance.getBinaryPath()); 
            this.withConcurrency(instance.getConcurrency()); 
            this.withConfigPath(instance.getConfigPath()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            this.withCustomConfigFile(instance.getCustomConfigFile()); 
            this.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            this.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            this.withDrainDuration(instance.getDrainDuration()); 
            this.withInterceptionMode(instance.getInterceptionMode()); 
            this.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            this.withProxyAdminPort(instance.getProxyAdminPort()); 
            this.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            this.withServiceCluster(instance.getServiceCluster()); 
            this.withStatNameLength(instance.getStatNameLength()); 
            this.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            this.withZipkinAddress(instance.getZipkinAddress()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ProxyConfig build(){
            ProxyConfig buildable = new ProxyConfig(fluent.getAvailabilityZone(),fluent.getBinaryPath(),fluent.getConcurrency(),fluent.getConfigPath(),fluent.getConnectTimeout(),fluent.getControlPlaneAuthPolicy(),fluent.getCustomConfigFile(),fluent.getDiscoveryAddress(),fluent.getDiscoveryRefreshDelay(),fluent.getDrainDuration(),fluent.getInterceptionMode(),fluent.getParentShutdownDuration(),fluent.getProxyAdminPort(),fluent.getProxyBootstrapTemplatePath(),fluent.getServiceCluster(),fluent.getStatNameLength(),fluent.getStatsdUdpAddress(),fluent.getZipkinAddress());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProxyConfigBuilder that = (ProxyConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
