package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class OutboundTrafficPolicyBuilder extends OutboundTrafficPolicyFluentImpl<OutboundTrafficPolicyBuilder> implements VisitableBuilder<OutboundTrafficPolicy,OutboundTrafficPolicyBuilder>{

    OutboundTrafficPolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OutboundTrafficPolicyBuilder(){
            this(true);
    }
    public OutboundTrafficPolicyBuilder(Boolean validationEnabled){
            this(new OutboundTrafficPolicy(), validationEnabled);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OutboundTrafficPolicy(), validationEnabled);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance){
            this(fluent, instance, true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance){
            this(instance,true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutboundTrafficPolicyBuilder(Validator validator){
            this(new OutboundTrafficPolicy(), true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMode(instance.getMode()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance,Validator validator){
            this.fluent = this; 
            this.withMode(instance.getMode()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public OutboundTrafficPolicy build(){
            OutboundTrafficPolicy buildable = new OutboundTrafficPolicy(fluent.getMode());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OutboundTrafficPolicyBuilder that = (OutboundTrafficPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
