
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.authentication.v1alpha1.PeerAuthenticationMethod.Params;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "mtls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MtlsParams implements Serializable, Params
{

    /**
     * 
     * 
     */
    @JsonProperty("mtls")
    @JsonPropertyDescription("")
    @Valid
    private MutualTls mtls;
    private final static long serialVersionUID = 7367133053996213654L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MtlsParams() {
    }

    /**
     * 
     * @param mtls
     */
    public MtlsParams(MutualTls mtls) {
        super();
        this.mtls = mtls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mtls")
    public MutualTls getMtls() {
        return mtls;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mtls")
    public void setMtls(MutualTls mtls) {
        this.mtls = mtls;
    }

}
