package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class JwtBuilder extends JwtFluentImpl<JwtBuilder> implements VisitableBuilder<Jwt,JwtBuilder>{

    JwtFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JwtBuilder(){
            this(true);
    }
    public JwtBuilder(Boolean validationEnabled){
            this(new Jwt(), validationEnabled);
    }
    public JwtBuilder(JwtFluent<?> fluent){
            this(fluent, true);
    }
    public JwtBuilder(JwtFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Jwt(), validationEnabled);
    }
    public JwtBuilder(JwtFluent<?> fluent,Jwt instance){
            this(fluent, instance, true);
    }
    public JwtBuilder(JwtFluent<?> fluent,Jwt instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAudiences(instance.getAudiences()); 
            fluent.withIssuer(instance.getIssuer()); 
            fluent.withJwksUri(instance.getJwksUri()); 
            fluent.withJwtHeaders(instance.getJwtHeaders()); 
            fluent.withJwtParams(instance.getJwtParams()); 
            this.validationEnabled = validationEnabled; 
    }
    public JwtBuilder(Jwt instance){
            this(instance,true);
    }
    public JwtBuilder(Jwt instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAudiences(instance.getAudiences()); 
            this.withIssuer(instance.getIssuer()); 
            this.withJwksUri(instance.getJwksUri()); 
            this.withJwtHeaders(instance.getJwtHeaders()); 
            this.withJwtParams(instance.getJwtParams()); 
            this.validationEnabled = validationEnabled; 
    }
    public JwtBuilder(Validator validator){
            this(new Jwt(), true);
    }
    public JwtBuilder(JwtFluent<?> fluent,Jwt instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAudiences(instance.getAudiences()); 
            fluent.withIssuer(instance.getIssuer()); 
            fluent.withJwksUri(instance.getJwksUri()); 
            fluent.withJwtHeaders(instance.getJwtHeaders()); 
            fluent.withJwtParams(instance.getJwtParams()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public JwtBuilder(Jwt instance,Validator validator){
            this.fluent = this; 
            this.withAudiences(instance.getAudiences()); 
            this.withIssuer(instance.getIssuer()); 
            this.withJwksUri(instance.getJwksUri()); 
            this.withJwtHeaders(instance.getJwtHeaders()); 
            this.withJwtParams(instance.getJwtParams()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Jwt build(){
            Jwt buildable = new Jwt(fluent.getAudiences(),fluent.getIssuer(),fluent.getJwksUri(),fluent.getJwtHeaders(),fluent.getJwtParams());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JwtBuilder that = (JwtBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
