package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface IstioResourceListFluent<A extends IstioResourceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,IstioResource item);
    public A setToItems(int index,IstioResource item);
    public A addToItems(IstioResource... items);
    public A addAllToItems(Collection<IstioResource> items);
    public A removeFromItems(IstioResource... items);
    public A removeAllFromItems(Collection<IstioResource> items);
    public List<IstioResource> getItems();
    public IstioResource getItem(int index);
    public IstioResource getFirstItem();
    public IstioResource getLastItem();
    public IstioResource getMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<IstioResource> predicate);
    public A withItems(List<IstioResource> items);
    public A withItems(IstioResource... items);
    public Boolean hasItems();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);



}
