package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class IstioBaseSpecBuilder extends IstioBaseSpecFluentImpl<IstioBaseSpecBuilder> implements VisitableBuilder<IstioBaseSpec,IstioBaseSpecBuilder>{

    IstioBaseSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IstioBaseSpecBuilder(){
            this(true);
    }
    public IstioBaseSpecBuilder(Boolean validationEnabled){
            this(new IstioBaseSpec(), validationEnabled);
    }
    public IstioBaseSpecBuilder(IstioBaseSpecFluent<?> fluent){
            this(fluent, true);
    }
    public IstioBaseSpecBuilder(IstioBaseSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IstioBaseSpec(), validationEnabled);
    }
    public IstioBaseSpecBuilder(IstioBaseSpecFluent<?> fluent,IstioBaseSpec instance){
            this(fluent, instance, true);
    }
    public IstioBaseSpecBuilder(IstioBaseSpecFluent<?> fluent,IstioBaseSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public IstioBaseSpecBuilder(IstioBaseSpec instance){
            this(instance,true);
    }
    public IstioBaseSpecBuilder(IstioBaseSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }
    public IstioBaseSpecBuilder(Validator validator){
            this(new IstioBaseSpec(), true);
    }
    public IstioBaseSpecBuilder(IstioBaseSpecFluent<?> fluent,IstioBaseSpec instance,Validator validator){
            this.fluent = fluent; 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public IstioBaseSpecBuilder(IstioBaseSpec instance,Validator validator){
            this.fluent = this; 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public IstioBaseSpec build(){
            IstioBaseSpec buildable = new IstioBaseSpec();
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IstioBaseSpecBuilder that = (IstioBaseSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
