/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.template.listentry;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.mixer.template.listentry.ListEntry;
import me.snowdrop.istio.mixer.template.listentry.ListEntryBuilder;
import me.snowdrop.istio.mixer.template.listentry.ListEntryFluentImpl;
import me.snowdrop.istio.mixer.template.listentry.ListEntryList;
import me.snowdrop.istio.mixer.template.listentry.ListEntryListFluent;

public class ListEntryListFluentImpl<A extends ListEntryListFluent<A>>
extends BaseFluent<A>
implements ListEntryListFluent<A> {
    private String apiVersion;
    private List<ListEntryBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ListEntryListFluentImpl() {
    }

    public ListEntryListFluentImpl(ListEntryList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, ListEntry item) {
        if (this.items == null) {
            this.items = new ArrayList<ListEntryBuilder>();
        }
        ListEntryBuilder builder = new ListEntryBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ListEntry item) {
        if (this.items == null) {
            this.items = new ArrayList<ListEntryBuilder>();
        }
        ListEntryBuilder builder = new ListEntryBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ListEntry ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ListEntryBuilder>();
        }
        for (ListEntry item : items) {
            ListEntryBuilder builder = new ListEntryBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ListEntry> items) {
        if (this.items == null) {
            this.items = new ArrayList<ListEntryBuilder>();
        }
        for (ListEntry item : items) {
            ListEntryBuilder builder = new ListEntryBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ListEntry ... items) {
        for (ListEntry item : items) {
            ListEntryBuilder builder = new ListEntryBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ListEntry> items) {
        for (ListEntry item : items) {
            ListEntryBuilder builder = new ListEntryBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ListEntry> getItems() {
        return ListEntryListFluentImpl.build(this.items);
    }

    @Override
    public List<ListEntry> buildItems() {
        return ListEntryListFluentImpl.build(this.items);
    }

    @Override
    public ListEntry buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ListEntry buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ListEntry buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ListEntry buildMatchingItem(Predicate<ListEntryBuilder> predicate) {
        for (ListEntryBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<ListEntry> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ListEntryBuilder>();
            for (ListEntry item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ListEntry ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ListEntry item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> addNewItemLike(ListEntry item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> setNewItemLike(int index, ListEntry item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ListEntryListFluent.ItemsNested<A> editMatchingItem(Predicate<ListEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListEntryListFluentImpl that = (ListEntryListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends ListEntryFluentImpl<ListEntryListFluent.ItemsNested<N>>
    implements ListEntryListFluent.ItemsNested<N>,
    Nested<N> {
        private final ListEntryBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ListEntry item) {
            this.index = index;
            this.builder = new ListEntryBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ListEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ListEntryListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

