/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.template.edge;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.mixer.template.edge.Edge;
import me.snowdrop.istio.mixer.template.edge.EdgeBuilder;
import me.snowdrop.istio.mixer.template.edge.EdgeFluentImpl;
import me.snowdrop.istio.mixer.template.edge.EdgeList;
import me.snowdrop.istio.mixer.template.edge.EdgeListFluent;

public class EdgeListFluentImpl<A extends EdgeListFluent<A>>
extends BaseFluent<A>
implements EdgeListFluent<A> {
    private String apiVersion;
    private List<EdgeBuilder> items;
    private String kind;
    private ListMeta metadata;

    public EdgeListFluentImpl() {
    }

    public EdgeListFluentImpl(EdgeList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, Edge item) {
        if (this.items == null) {
            this.items = new ArrayList<EdgeBuilder>();
        }
        EdgeBuilder builder = new EdgeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Edge item) {
        if (this.items == null) {
            this.items = new ArrayList<EdgeBuilder>();
        }
        EdgeBuilder builder = new EdgeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Edge ... items) {
        if (this.items == null) {
            this.items = new ArrayList<EdgeBuilder>();
        }
        for (Edge item : items) {
            EdgeBuilder builder = new EdgeBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Edge> items) {
        if (this.items == null) {
            this.items = new ArrayList<EdgeBuilder>();
        }
        for (Edge item : items) {
            EdgeBuilder builder = new EdgeBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Edge ... items) {
        for (Edge item : items) {
            EdgeBuilder builder = new EdgeBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Edge> items) {
        for (Edge item : items) {
            EdgeBuilder builder = new EdgeBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Edge> getItems() {
        return EdgeListFluentImpl.build(this.items);
    }

    @Override
    public List<Edge> buildItems() {
        return EdgeListFluentImpl.build(this.items);
    }

    @Override
    public Edge buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Edge buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Edge buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Edge buildMatchingItem(Predicate<EdgeBuilder> predicate) {
        for (EdgeBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<Edge> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<EdgeBuilder>();
            for (Edge item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Edge ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Edge item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public EdgeListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public EdgeListFluent.ItemsNested<A> addNewItemLike(Edge item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public EdgeListFluent.ItemsNested<A> setNewItemLike(int index, Edge item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public EdgeListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public EdgeListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public EdgeListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public EdgeListFluent.ItemsNested<A> editMatchingItem(Predicate<EdgeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EdgeListFluentImpl that = (EdgeListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends EdgeFluentImpl<EdgeListFluent.ItemsNested<N>>
    implements EdgeListFluent.ItemsNested<N>,
    Nested<N> {
        private final EdgeBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Edge item) {
            this.index = index;
            this.builder = new EdgeBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new EdgeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EdgeListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

