/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.adapter.servicecontrol.GcpServiceSetting;
import me.snowdrop.istio.adapter.servicecontrol.GcpServiceSettingBuilder;
import me.snowdrop.istio.adapter.servicecontrol.GcpServiceSettingFluentImpl;
import me.snowdrop.istio.adapter.servicecontrol.RuntimeConfig;
import me.snowdrop.istio.adapter.servicecontrol.RuntimeConfigBuilder;
import me.snowdrop.istio.adapter.servicecontrol.RuntimeConfigFluentImpl;
import me.snowdrop.istio.adapter.servicecontrol.ServicecontrolSpec;
import me.snowdrop.istio.adapter.servicecontrol.ServicecontrolSpecFluent;

public class ServicecontrolSpecFluentImpl<A extends ServicecontrolSpecFluent<A>>
extends BaseFluent<A>
implements ServicecontrolSpecFluent<A> {
    private String credentialPath;
    private RuntimeConfigBuilder runtimeConfig;
    private List<GcpServiceSettingBuilder> serviceConfigs;

    public ServicecontrolSpecFluentImpl() {
    }

    public ServicecontrolSpecFluentImpl(ServicecontrolSpec instance) {
        this.withCredentialPath(instance.getCredentialPath());
        this.withRuntimeConfig(instance.getRuntimeConfig());
        this.withServiceConfigs(instance.getServiceConfigs());
    }

    @Override
    public String getCredentialPath() {
        return this.credentialPath;
    }

    @Override
    public A withCredentialPath(String credentialPath) {
        this.credentialPath = credentialPath;
        return (A)this;
    }

    @Override
    public Boolean hasCredentialPath() {
        return this.credentialPath != null;
    }

    @Override
    @Deprecated
    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig != null ? this.runtimeConfig.build() : null;
    }

    @Override
    public RuntimeConfig buildRuntimeConfig() {
        return this.runtimeConfig != null ? this.runtimeConfig.build() : null;
    }

    @Override
    public A withRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._visitables.remove(this.runtimeConfig);
        if (runtimeConfig != null) {
            this.runtimeConfig = new RuntimeConfigBuilder(runtimeConfig);
            this._visitables.add(this.runtimeConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeConfig() {
        return this.runtimeConfig != null;
    }

    @Override
    public ServicecontrolSpecFluent.RuntimeConfigNested<A> withNewRuntimeConfig() {
        return new RuntimeConfigNestedImpl();
    }

    @Override
    public ServicecontrolSpecFluent.RuntimeConfigNested<A> withNewRuntimeConfigLike(RuntimeConfig item) {
        return new RuntimeConfigNestedImpl(item);
    }

    @Override
    public ServicecontrolSpecFluent.RuntimeConfigNested<A> editRuntimeConfig() {
        return this.withNewRuntimeConfigLike(this.getRuntimeConfig());
    }

    @Override
    public ServicecontrolSpecFluent.RuntimeConfigNested<A> editOrNewRuntimeConfig() {
        return this.withNewRuntimeConfigLike(this.getRuntimeConfig() != null ? this.getRuntimeConfig() : new RuntimeConfigBuilder().build());
    }

    @Override
    public ServicecontrolSpecFluent.RuntimeConfigNested<A> editOrNewRuntimeConfigLike(RuntimeConfig item) {
        return this.withNewRuntimeConfigLike(this.getRuntimeConfig() != null ? this.getRuntimeConfig() : item);
    }

    @Override
    public A addToServiceConfigs(int index, GcpServiceSetting item) {
        if (this.serviceConfigs == null) {
            this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();
        }
        GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.serviceConfigs.add(index >= 0 ? index : this.serviceConfigs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServiceConfigs(int index, GcpServiceSetting item) {
        if (this.serviceConfigs == null) {
            this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();
        }
        GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.serviceConfigs.size()) {
            this.serviceConfigs.add(builder);
        } else {
            this.serviceConfigs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServiceConfigs(GcpServiceSetting ... items) {
        if (this.serviceConfigs == null) {
            this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();
        }
        for (GcpServiceSetting item : items) {
            GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
            this._visitables.add(builder);
            this.serviceConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceConfigs(Collection<GcpServiceSetting> items) {
        if (this.serviceConfigs == null) {
            this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();
        }
        for (GcpServiceSetting item : items) {
            GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
            this._visitables.add(builder);
            this.serviceConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceConfigs(GcpServiceSetting ... items) {
        for (GcpServiceSetting item : items) {
            GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
            this._visitables.remove(builder);
            if (this.serviceConfigs == null) continue;
            this.serviceConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceConfigs(Collection<GcpServiceSetting> items) {
        for (GcpServiceSetting item : items) {
            GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
            this._visitables.remove(builder);
            if (this.serviceConfigs == null) continue;
            this.serviceConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GcpServiceSetting> getServiceConfigs() {
        return ServicecontrolSpecFluentImpl.build(this.serviceConfigs);
    }

    @Override
    public List<GcpServiceSetting> buildServiceConfigs() {
        return ServicecontrolSpecFluentImpl.build(this.serviceConfigs);
    }

    @Override
    public GcpServiceSetting buildServiceConfig(int index) {
        return this.serviceConfigs.get(index).build();
    }

    @Override
    public GcpServiceSetting buildFirstServiceConfig() {
        return this.serviceConfigs.get(0).build();
    }

    @Override
    public GcpServiceSetting buildLastServiceConfig() {
        return this.serviceConfigs.get(this.serviceConfigs.size() - 1).build();
    }

    @Override
    public GcpServiceSetting buildMatchingServiceConfig(Predicate<GcpServiceSettingBuilder> predicate) {
        for (GcpServiceSettingBuilder item : this.serviceConfigs) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withServiceConfigs(List<GcpServiceSetting> serviceConfigs) {
        if (this.serviceConfigs != null) {
            this._visitables.removeAll(this.serviceConfigs);
        }
        if (serviceConfigs != null) {
            this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();
            for (GcpServiceSetting item : serviceConfigs) {
                this.addToServiceConfigs(item);
            }
        } else {
            this.serviceConfigs = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceConfigs(GcpServiceSetting ... serviceConfigs) {
        if (this.serviceConfigs != null) {
            this.serviceConfigs.clear();
        }
        if (serviceConfigs != null) {
            for (GcpServiceSetting item : serviceConfigs) {
                this.addToServiceConfigs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceConfigs() {
        return this.serviceConfigs != null && !this.serviceConfigs.isEmpty();
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> addNewServiceConfig() {
        return new ServiceConfigsNestedImpl();
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> addNewServiceConfigLike(GcpServiceSetting item) {
        return new ServiceConfigsNestedImpl(-1, item);
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> setNewServiceConfigLike(int index, GcpServiceSetting item) {
        return new ServiceConfigsNestedImpl(index, item);
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editServiceConfig(int index) {
        if (this.serviceConfigs.size() <= index) {
            throw new RuntimeException("Can't edit serviceConfigs. Index exceeds size.");
        }
        return this.setNewServiceConfigLike(index, this.buildServiceConfig(index));
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editFirstServiceConfig() {
        if (this.serviceConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first serviceConfigs. The list is empty.");
        }
        return this.setNewServiceConfigLike(0, this.buildServiceConfig(0));
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editLastServiceConfig() {
        int index = this.serviceConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceConfigs. The list is empty.");
        }
        return this.setNewServiceConfigLike(index, this.buildServiceConfig(index));
    }

    @Override
    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editMatchingServiceConfig(Predicate<GcpServiceSettingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceConfigs.size(); ++i) {
            if (!predicate.apply((Object)this.serviceConfigs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceConfigs. No match found.");
        }
        return this.setNewServiceConfigLike(index, this.buildServiceConfig(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicecontrolSpecFluentImpl that = (ServicecontrolSpecFluentImpl)o;
        if (this.credentialPath != null ? !this.credentialPath.equals(that.credentialPath) : that.credentialPath != null) {
            return false;
        }
        if (this.runtimeConfig != null ? !this.runtimeConfig.equals(that.runtimeConfig) : that.runtimeConfig != null) {
            return false;
        }
        return !(this.serviceConfigs != null ? !this.serviceConfigs.equals(that.serviceConfigs) : that.serviceConfigs != null);
    }

    public class ServiceConfigsNestedImpl<N>
    extends GcpServiceSettingFluentImpl<ServicecontrolSpecFluent.ServiceConfigsNested<N>>
    implements ServicecontrolSpecFluent.ServiceConfigsNested<N>,
    Nested<N> {
        private final GcpServiceSettingBuilder builder;
        private final int index;

        ServiceConfigsNestedImpl(int index, GcpServiceSetting item) {
            this.index = index;
            this.builder = new GcpServiceSettingBuilder(this, item);
        }

        ServiceConfigsNestedImpl() {
            this.index = -1;
            this.builder = new GcpServiceSettingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicecontrolSpecFluentImpl.this.setToServiceConfigs(this.index, this.builder.build());
        }

        @Override
        public N endServiceConfig() {
            return this.and();
        }
    }

    public class RuntimeConfigNestedImpl<N>
    extends RuntimeConfigFluentImpl<ServicecontrolSpecFluent.RuntimeConfigNested<N>>
    implements ServicecontrolSpecFluent.RuntimeConfigNested<N>,
    Nested<N> {
        private final RuntimeConfigBuilder builder;

        RuntimeConfigNestedImpl(RuntimeConfig item) {
            this.builder = new RuntimeConfigBuilder(this, item);
        }

        RuntimeConfigNestedImpl() {
            this.builder = new RuntimeConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicecontrolSpecFluentImpl.this.withRuntimeConfig(this.builder.build());
        }

        @Override
        public N endRuntimeConfig() {
            return this.and();
        }
    }
}

