/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.adapter.servicecontrol.GcpServiceSetting;
import me.snowdrop.istio.adapter.servicecontrol.GcpServiceSettingFluent;
import me.snowdrop.istio.adapter.servicecontrol.Quota;
import me.snowdrop.istio.adapter.servicecontrol.QuotaBuilder;
import me.snowdrop.istio.adapter.servicecontrol.QuotaFluentImpl;

public class GcpServiceSettingFluentImpl<A extends GcpServiceSettingFluent<A>>
extends BaseFluent<A>
implements GcpServiceSettingFluent<A> {
    private String googleServiceName;
    private String meshServiceName;
    private List<QuotaBuilder> quotas;

    public GcpServiceSettingFluentImpl() {
    }

    public GcpServiceSettingFluentImpl(GcpServiceSetting instance) {
        this.withGoogleServiceName(instance.getGoogleServiceName());
        this.withMeshServiceName(instance.getMeshServiceName());
        this.withQuotas(instance.getQuotas());
    }

    @Override
    public String getGoogleServiceName() {
        return this.googleServiceName;
    }

    @Override
    public A withGoogleServiceName(String googleServiceName) {
        this.googleServiceName = googleServiceName;
        return (A)this;
    }

    @Override
    public Boolean hasGoogleServiceName() {
        return this.googleServiceName != null;
    }

    @Override
    public String getMeshServiceName() {
        return this.meshServiceName;
    }

    @Override
    public A withMeshServiceName(String meshServiceName) {
        this.meshServiceName = meshServiceName;
        return (A)this;
    }

    @Override
    public Boolean hasMeshServiceName() {
        return this.meshServiceName != null;
    }

    @Override
    public A addToQuotas(int index, Quota item) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        QuotaBuilder builder = new QuotaBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.quotas.add(index >= 0 ? index : this.quotas.size(), builder);
        return (A)this;
    }

    @Override
    public A setToQuotas(int index, Quota item) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        QuotaBuilder builder = new QuotaBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.quotas.size()) {
            this.quotas.add(builder);
        } else {
            this.quotas.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToQuotas(Quota ... items) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.add(builder);
            this.quotas.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToQuotas(Collection<Quota> items) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.add(builder);
            this.quotas.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromQuotas(Quota ... items) {
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.remove(builder);
            if (this.quotas == null) continue;
            this.quotas.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromQuotas(Collection<Quota> items) {
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.remove(builder);
            if (this.quotas == null) continue;
            this.quotas.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Quota> getQuotas() {
        return GcpServiceSettingFluentImpl.build(this.quotas);
    }

    @Override
    public List<Quota> buildQuotas() {
        return GcpServiceSettingFluentImpl.build(this.quotas);
    }

    @Override
    public Quota buildQuota(int index) {
        return this.quotas.get(index).build();
    }

    @Override
    public Quota buildFirstQuota() {
        return this.quotas.get(0).build();
    }

    @Override
    public Quota buildLastQuota() {
        return this.quotas.get(this.quotas.size() - 1).build();
    }

    @Override
    public Quota buildMatchingQuota(Predicate<QuotaBuilder> predicate) {
        for (QuotaBuilder item : this.quotas) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withQuotas(List<Quota> quotas) {
        if (this.quotas != null) {
            this._visitables.removeAll(this.quotas);
        }
        if (quotas != null) {
            this.quotas = new ArrayList<QuotaBuilder>();
            for (Quota item : quotas) {
                this.addToQuotas(item);
            }
        } else {
            this.quotas = null;
        }
        return (A)this;
    }

    @Override
    public A withQuotas(Quota ... quotas) {
        if (this.quotas != null) {
            this.quotas.clear();
        }
        if (quotas != null) {
            for (Quota item : quotas) {
                this.addToQuotas(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasQuotas() {
        return this.quotas != null && !this.quotas.isEmpty();
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> addNewQuota() {
        return new QuotasNestedImpl();
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> addNewQuotaLike(Quota item) {
        return new QuotasNestedImpl(-1, item);
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> setNewQuotaLike(int index, Quota item) {
        return new QuotasNestedImpl(index, item);
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> editQuota(int index) {
        if (this.quotas.size() <= index) {
            throw new RuntimeException("Can't edit quotas. Index exceeds size.");
        }
        return this.setNewQuotaLike(index, this.buildQuota(index));
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> editFirstQuota() {
        if (this.quotas.size() == 0) {
            throw new RuntimeException("Can't edit first quotas. The list is empty.");
        }
        return this.setNewQuotaLike(0, this.buildQuota(0));
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> editLastQuota() {
        int index = this.quotas.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last quotas. The list is empty.");
        }
        return this.setNewQuotaLike(index, this.buildQuota(index));
    }

    @Override
    public GcpServiceSettingFluent.QuotasNested<A> editMatchingQuota(Predicate<QuotaBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.quotas.size(); ++i) {
            if (!predicate.apply((Object)this.quotas.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching quotas. No match found.");
        }
        return this.setNewQuotaLike(index, this.buildQuota(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GcpServiceSettingFluentImpl that = (GcpServiceSettingFluentImpl)o;
        if (this.googleServiceName != null ? !this.googleServiceName.equals(that.googleServiceName) : that.googleServiceName != null) {
            return false;
        }
        if (this.meshServiceName != null ? !this.meshServiceName.equals(that.meshServiceName) : that.meshServiceName != null) {
            return false;
        }
        return !(this.quotas != null ? !this.quotas.equals(that.quotas) : that.quotas != null);
    }

    public class QuotasNestedImpl<N>
    extends QuotaFluentImpl<GcpServiceSettingFluent.QuotasNested<N>>
    implements GcpServiceSettingFluent.QuotasNested<N>,
    Nested<N> {
        private final QuotaBuilder builder;
        private final int index;

        QuotasNestedImpl(int index, Quota item) {
            this.index = index;
            this.builder = new QuotaBuilder(this, item);
        }

        QuotasNestedImpl() {
            this.index = -1;
            this.builder = new QuotaBuilder(this);
        }

        @Override
        public N and() {
            return (N)GcpServiceSettingFluentImpl.this.setToQuotas(this.index, this.builder.build());
        }

        @Override
        public N endQuota() {
            return this.and();
        }
    }
}

