/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.redisquota;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.adapter.redisquota.Quota;
import me.snowdrop.istio.adapter.redisquota.QuotaFluent;
import me.snowdrop.istio.adapter.redisquota.QuotaFluentImpl;

public class QuotaBuilder
extends QuotaFluentImpl<QuotaBuilder>
implements VisitableBuilder<Quota, QuotaBuilder> {
    QuotaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public QuotaBuilder() {
        this(true);
    }

    public QuotaBuilder(Boolean validationEnabled) {
        this(new Quota(), validationEnabled);
    }

    public QuotaBuilder(QuotaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public QuotaBuilder(QuotaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Quota(), validationEnabled);
    }

    public QuotaBuilder(QuotaFluent<?> fluent, Quota instance) {
        this(fluent, instance, true);
    }

    public QuotaBuilder(QuotaFluent<?> fluent, Quota instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBucketDuration(instance.getBucketDuration());
        fluent.withMaxAmount(instance.getMaxAmount());
        fluent.withName(instance.getName());
        fluent.withOverrides(instance.getOverrides());
        fluent.withRateLimitAlgorithm(instance.getRateLimitAlgorithm());
        fluent.withValidDuration(instance.getValidDuration());
        this.validationEnabled = validationEnabled;
    }

    public QuotaBuilder(Quota instance) {
        this(instance, (Boolean)true);
    }

    public QuotaBuilder(Quota instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBucketDuration(instance.getBucketDuration());
        this.withMaxAmount(instance.getMaxAmount());
        this.withName(instance.getName());
        this.withOverrides(instance.getOverrides());
        this.withRateLimitAlgorithm(instance.getRateLimitAlgorithm());
        this.withValidDuration(instance.getValidDuration());
        this.validationEnabled = validationEnabled;
    }

    public QuotaBuilder(Validator validator) {
        this(new Quota(), (Boolean)true);
    }

    public QuotaBuilder(QuotaFluent<?> fluent, Quota instance, Validator validator) {
        this.fluent = fluent;
        fluent.withBucketDuration(instance.getBucketDuration());
        fluent.withMaxAmount(instance.getMaxAmount());
        fluent.withName(instance.getName());
        fluent.withOverrides(instance.getOverrides());
        fluent.withRateLimitAlgorithm(instance.getRateLimitAlgorithm());
        fluent.withValidDuration(instance.getValidDuration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public QuotaBuilder(Quota instance, Validator validator) {
        this.fluent = this;
        this.withBucketDuration(instance.getBucketDuration());
        this.withMaxAmount(instance.getMaxAmount());
        this.withName(instance.getName());
        this.withOverrides(instance.getOverrides());
        this.withRateLimitAlgorithm(instance.getRateLimitAlgorithm());
        this.withValidDuration(instance.getValidDuration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Quota build() {
        Quota buildable = new Quota(this.fluent.getBucketDuration(), this.fluent.getMaxAmount(), this.fluent.getName(), this.fluent.getOverrides(), this.fluent.getRateLimitAlgorithm(), this.fluent.getValidDuration());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuotaBuilder that = (QuotaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

