/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.snowdrop.istio.api.model.IstioSpec;

public class IstioSpecRegistry {
    private static final String ISTIO_PACKAGE_PREFIX = "me.snowdrop.istio.";
    private static final String ISTIO_API_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.";
    private static final String ISTIO_VERSION = "v1.";
    private static final String ISTIO_MIXER_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.mixer.";
    private static final String ISTIO_MIXER_TEMPLATE_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.mixer.template.";
    private static final String ISTIO_ROUTING_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.routing.";
    private static final String ISTIO_NETWORKING_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.networking.";
    private static final String ISTIO_ADAPTER_PACKAGE_PREFIX = "me.snowdrop.istio.adapter.";
    private static final Map<String, CRDInfo> crdInfos = new HashMap<String, CRDInfo>();

    private static void loadCRDInfosFromProperties(String propertyFileName, Function<String, String> packageNameFromPropertyKey) {
        Properties crdFile = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFileName);){
            crdFile.load(inputStream);
        }
        catch (Exception e2) {
            throw new RuntimeException("Couldn't load '" + propertyFileName + "' from classpath", e2);
        }
        crdInfos.putAll(crdFile.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> IstioSpecRegistry.getCRDInfoFrom(e, (String)packageNameFromPropertyKey.apply(e.getKey().toString())))));
    }

    private static CRDInfo getCRDInfoFrom(Map.Entry<Object, Object> entry, String packageName) {
        String kind = String.valueOf(entry.getKey());
        String className = kind.contains("entry") ? kind.replace("entry", "Entry") : (kind.contains("Msg") ? kind.replace("Msg", "") : (kind.contains("nothing") ? kind.replace("nothing", "Nothing") : (kind.contains("key") ? kind.replace("key", "Key") : (kind.contains("span") ? kind.replace("span", "Span") : kind))));
        char c = className.charAt(0);
        className = className.replaceFirst("" + c, "" + Character.toTitleCase(c));
        return new CRDInfo(kind, String.valueOf(entry.getValue()), packageName + className);
    }

    public static Class<? extends IstioSpec> resolveIstioSpecForKind(String name) {
        CRDInfo crdInfo = crdInfos.get(name);
        if (crdInfo != null) {
            Optional result = crdInfo.clazz;
            if (!result.isPresent()) {
                Class<? extends IstioSpec> clazz = IstioSpecRegistry.loadClassIfExists(crdInfo.className);
                crdInfo.clazz = Optional.of(clazz);
                return clazz;
            }
            return (Class)result.get();
        }
        return null;
    }

    public static String getKindFor(Class<? extends IstioSpec> spec) {
        try {
            return spec.newInstance().getKind();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Optional<String> getIstioKind(String simpleClassName) {
        if (crdInfos.containsKey(simpleClassName)) {
            return Optional.of(simpleClassName);
        }
        String lowerSimpleClassName = simpleClassName.toLowerCase();
        return crdInfos.containsKey(lowerSimpleClassName) ? Optional.of(lowerSimpleClassName) : Optional.empty();
    }

    public static Optional<String> getCRDNameFor(String kind) {
        CRDInfo crdInfo = crdInfos.get(kind);
        return crdInfo != null ? Optional.of(crdInfo.crdName) : Optional.empty();
    }

    public static Set<String> getKnownKinds() {
        return crdInfos.keySet();
    }

    private static Class<? extends IstioSpec> loadClassIfExists(String className) {
        try {
            Class<?> loaded = IstioSpecRegistry.class.getClassLoader().loadClass(className);
            if (IstioSpec.class.isAssignableFrom(loaded)) {
                return loaded.asSubclass(IstioSpec.class);
            }
            throw new IllegalArgumentException(String.format("%s is not an implementation of %s", className, IstioSpec.class.getSimpleName()));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.format("Cannot load class: %s", className), t);
        }
    }

    static {
        IstioSpecRegistry.loadCRDInfosFromProperties("adapter_crds.properties", key -> ISTIO_ADAPTER_PACKAGE_PREFIX + key.toLowerCase() + ".");
        IstioSpecRegistry.loadCRDInfosFromProperties("template_crds.properties", key -> ISTIO_MIXER_TEMPLATE_PACKAGE_PREFIX);
        IstioSpecRegistry.loadCRDInfosFromProperties("other_crds.properties", key -> ISTIO_ROUTING_PACKAGE_PREFIX);
        IstioSpecRegistry.loadCRDInfosFromProperties("networking_crds.properties", key -> ISTIO_NETWORKING_PACKAGE_PREFIX);
        IstioSpecRegistry.loadCRDInfosFromProperties("additional_resources.properties", key -> ISTIO_PACKAGE_PREFIX);
    }

    static class CRDInfo {
        private final String kind;
        private final String crdName;
        private final String className;
        private Optional<Class<? extends IstioSpec>> clazz = Optional.empty();

        public CRDInfo(String kind, String crdName, String className) {
            this.kind = kind;
            this.crdName = crdName;
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CRDInfo crdInfo = (CRDInfo)o;
            return this.kind.equals(crdInfo.kind);
        }

        public int hashCode() {
            return this.kind.hashCode();
        }

        public String toString() {
            return "CRDInfo{kind='" + this.kind + '\'' + ", crdName='" + this.crdName + '\'' + ", className='" + this.className + '\'' + '}';
        }
    }
}

