/*
 * Decompiled with CFR 0.152.
 */
package me.simple.state_adapter;

import android.content.Context;
import android.database.Observable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import me.simple.state_adapter.BaseStateView;
import me.simple.state_adapter.IStateView;
import me.simple.state_adapter.StateViewHolder;

public class StateAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final int VIEW_TYPE_STATE = 1111;
    private RecyclerView.Adapter mRealAdapter;
    private IStateView mStateView;
    public static final int STATE_LOADING = 0;
    public static final int STATE_EMPTY = 1;
    public static final int STATE_ERROR = 2;
    public static final int STATE_RETRY = 3;
    public static final int STATE_CONTENT = 4;
    private int mCurrentState = 0;
    private OnRetryItemClickListener mOnRetryItemClickListener;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            StateAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            StateAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            StateAdapter.this.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            StateAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            StateAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            StateAdapter.this.notifyItemRangeChanged(fromPosition, toPosition, itemCount);
        }
    };

    private StateAdapter(RecyclerView.Adapter adapter) {
        this(adapter, new BaseStateView());
    }

    private StateAdapter(RecyclerView.Adapter adapter, IStateView stateView) {
        if (adapter == null) {
            throw new NullPointerException("adapter can not be null");
        }
        this.mRealAdapter = adapter;
        this.mStateView = stateView;
    }

    public static StateAdapter wrap(RecyclerView.Adapter adapter) {
        return new StateAdapter(adapter);
    }

    public static StateAdapter wrap(RecyclerView.Adapter adapter, IStateView stateView) {
        return new StateAdapter(adapter, stateView);
    }

    public StateAdapter setOnRetryItemClickListener(OnRetryItemClickListener listener) {
        this.mOnRetryItemClickListener = listener;
        return this;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        if (this.mStateView == null) {
            throw new NullPointerException("State View no implements");
        }
        if (viewType == 1111) {
            LayoutInflater inflater = LayoutInflater.from((Context)viewGroup.getContext());
            View stateView = inflater.inflate(this.mStateView.setLayoutRes(), viewGroup, false);
            this.mStateView.onCreate(stateView);
            return new StateViewHolder(stateView, this.mStateView);
        }
        return this.mRealAdapter.onCreateViewHolder(viewGroup, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position, List<Object> payloads) {
        int viewType = this.getItemViewType(position);
        if (viewType == 1111) {
            final StateViewHolder holder = (StateViewHolder)viewHolder;
            holder.setState(this.mCurrentState);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StateAdapter.this.mOnRetryItemClickListener == null || StateAdapter.this.mCurrentState != 3) {
                        return;
                    }
                    StateAdapter.this.mOnRetryItemClickListener.onClick(holder, holder.getAdapterPosition());
                }
            });
        } else {
            this.mRealAdapter.onBindViewHolder(viewHolder, position, payloads);
        }
    }

    public int getItemCount() {
        if (this.mRealAdapter.getItemCount() == 0) {
            return 1;
        }
        return this.mRealAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.mRealAdapter.getItemCount() == 0) {
            return 1111;
        }
        return this.mRealAdapter.getItemViewType(position);
    }

    public long getItemId(int position) {
        if (position == 0 && this.mRealAdapter.getItemCount() == 0) {
            return position;
        }
        return this.mRealAdapter.getItemId(position);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            return false;
        }
        return this.mRealAdapter.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            return;
        }
        this.mRealAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            return;
        }
        this.mRealAdapter.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (holder instanceof StateViewHolder) {
            return;
        }
        this.mRealAdapter.onViewRecycled(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.setFullSpan(recyclerView);
        if (!this.isRegistered()) {
            this.mRealAdapter.registerAdapterDataObserver(this.mDataObserver);
        }
        this.mRealAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.isRegistered()) {
            this.mRealAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mRealAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    private void setFullSpan(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gm = (GridLayoutManager)layoutManager;
            gm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int viewType = StateAdapter.this.getItemViewType(position);
                    if (viewType == 1111) {
                        return gm.getSpanCount();
                    }
                    return 1;
                }
            });
        }
    }

    private boolean isRegistered() {
        boolean isRegistered = false;
        try {
            Class<RecyclerView.Adapter> clazz = RecyclerView.Adapter.class;
            Field field = clazz.getDeclaredField("mObservable");
            field.setAccessible(true);
            Observable observable = (Observable)field.get(this.mRealAdapter);
            Field observersField = Observable.class.getDeclaredField("mObservers");
            observersField.setAccessible(true);
            ArrayList list = (ArrayList)observersField.get(observable);
            isRegistered = list.contains(this.mDataObserver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isRegistered;
    }

    public void showLoading() {
        this.mCurrentState = 0;
        this.notifyStateVH();
    }

    public void showEmpty() {
        this.mCurrentState = 1;
        this.notifyStateVH();
    }

    public void showError() {
        this.mCurrentState = 2;
        this.notifyStateVH();
    }

    public void showRetry() {
        this.mCurrentState = 3;
        this.notifyStateVH();
    }

    private void notifyStateVH() {
        this.notifyItemChanged(0);
    }

    public static interface OnRetryItemClickListener {
        public void onClick(StateViewHolder var1, int var2);
    }
}

