/*
 * Decompiled with CFR 0.152.
 */
package me.rosuh.filepicker.adapter;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.collection.ArraySet;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.rosuh.filepicker.FilePickerActivity;
import me.rosuh.filepicker.R;
import me.rosuh.filepicker.adapter.BaseAdapter;
import me.rosuh.filepicker.adapter.FileListAdapter;
import me.rosuh.filepicker.bean.FileBean;
import me.rosuh.filepicker.bean.FileItemBeanImpl;
import me.rosuh.filepicker.config.FilePickerManager;
import me.rosuh.filepicker.engine.ImageLoadController;
import me.rosuh.filepicker.filetype.FileType;
import me.rosuh.filepicker.filetype.RasterImageFileType;
import me.rosuh.filepicker.filetype.VideoFileType;
import me.rosuh.filepicker.utils.FileListAdapterListener;
import me.rosuh.filepicker.utils.FileListAdapterListenerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 E2\u00020\u0001:\u0003DEFB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010 \u001a\u00020!2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020!0#\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020!J\u0012\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020\bH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010)\u001a\u00020\bH\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0016J\u000e\u0010.\u001a\u00020!2\u0006\u0010)\u001a\u00020\bJ8\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u0005022\f\u00103\u001a\b\u0012\u0004\u0012\u00020!02H\u0086\b\u00f8\u0001\u0000J\u000e\u00104\u001a\u00020!2\u0006\u0010)\u001a\u00020\bJ\u0018\u00105\u001a\u00020!2\u0006\u00106\u001a\u0002072\u0006\u0010)\u001a\u00020\bH\u0016J&\u00105\u001a\u00020!2\u0006\u00106\u001a\u0002072\u0006\u0010)\u001a\u00020\b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0016J\u0018\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\bH\u0016J\u0006\u0010?\u001a\u00020!J\u0016\u0010@\u001a\u00020!2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010BJ\u000e\u0010C\u001a\u00020!2\u0006\u0010)\u001a\u00020\bR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006G"}, d2={"Lme/rosuh/filepicker/adapter/FileListAdapter;", "Lme/rosuh/filepicker/adapter/BaseAdapter;", "context", "Lme/rosuh/filepicker/FilePickerActivity;", "isSingleChoice", "", "(Lme/rosuh/filepicker/FilePickerActivity;Z)V", "checkedCount", "", "getCheckedCount", "()I", "checkedSet", "Landroidx/collection/ArraySet;", "Lme/rosuh/filepicker/bean/FileBean;", "getCheckedSet", "()Landroidx/collection/ArraySet;", "checkedSet$delegate", "Lkotlin/Lazy;", "dataList", "Ljava/util/ArrayList;", "Lme/rosuh/filepicker/bean/FileItemBeanImpl;", "Lkotlin/collections/ArrayList;", "getDataList", "()Ljava/util/ArrayList;", "()Z", "setSingleChoice", "(Z)V", "latestChoicePos", "listener", "Lme/rosuh/filepicker/utils/FileListAdapterListener;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "addListener", "", "block", "Lkotlin/Function1;", "Lme/rosuh/filepicker/utils/FileListAdapterListenerBuilder;", "Lkotlin/ExtensionFunctionType;", "checkAll", "disCheckAll", "getItem", "position", "getItemCount", "getItemView", "Landroid/view/View;", "getItemViewType", "multipleCheck", "multipleCheckOrNo", "item", "isCanSelect", "Lkotlin/Function0;", "checkFailedFunc", "multipleDisCheck", "onBindViewHolder", "holder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "resetCheck", "setNewData", "list", "", "singleCheck", "BaseViewHolder", "Companion", "FileListItemHolder", "filepicker_release"})
public final class FileListAdapter
extends BaseAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FilePickerActivity context;
    private boolean isSingleChoice;
    @NotNull
    private final ArrayList<FileItemBeanImpl> dataList;
    private int latestChoicePos;
    private RecyclerView recyclerView;
    @Nullable
    private FileListAdapterListener listener;
    @NotNull
    private final Lazy checkedSet$delegate;
    public static final int DEFAULT_FILE_TYPE = 10001;

    public FileListAdapter(@NotNull FilePickerActivity context, boolean isSingleChoice) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.isSingleChoice = isSingleChoice;
        this.dataList = new ArrayList(10);
        this.latestChoicePos = -1;
        this.checkedSet$delegate = LazyKt.lazy((Function0)checkedSet.2.INSTANCE);
    }

    public /* synthetic */ FileListAdapter(FilePickerActivity filePickerActivity, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice();
        }
        this(filePickerActivity, bl);
    }

    public final boolean isSingleChoice() {
        return this.isSingleChoice;
    }

    public final void setSingleChoice(boolean bl) {
        this.isSingleChoice = bl;
    }

    @NotNull
    public final ArrayList<FileItemBeanImpl> getDataList() {
        return this.dataList;
    }

    public final void addListener(@NotNull Function1<? super FileListAdapterListenerBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        FileListAdapterListenerBuilder fileListAdapterListenerBuilder = new FileListAdapterListenerBuilder();
        block.invoke((Object)fileListAdapterListenerBuilder);
        this.listener = fileListAdapterListenerBuilder;
    }

    private final ArraySet<FileBean> getCheckedSet() {
        Lazy lazy = this.checkedSet$delegate;
        return (ArraySet)lazy.getValue();
    }

    public final int getCheckedCount() {
        return ((Collection)this.getCheckedSet()).size();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (parent instanceof RecyclerView) {
            this.recyclerView = (RecyclerView)parent;
        }
        View view = LayoutInflater.from((Context)((Context)this.context)).inflate(R.layout.item_list_file_picker, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(context).inflate(\n \u2026      false\n            )");
        return new FileListItemHolder(view);
    }

    @Override
    @Nullable
    public View getItemView(int position) {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            recyclerView = null;
        }
        RecyclerView.ViewHolder viewHolder = recyclerView.findViewHolderForAdapterPosition(position);
        return viewHolder == null ? null : viewHolder.itemView;
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    public int getItemViewType(int position) {
        return 10001;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        FileItemBeanImpl fileItemBeanImpl = this.getItem(position);
        if (fileItemBeanImpl == null) {
            return;
        }
        FileItemBeanImpl item = fileItemBeanImpl;
        ((BaseViewHolder)holder).bind(item, position);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position, @NotNull List<Object> payloads) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            this.onBindViewHolder(holder, position);
            return;
        }
        FileItemBeanImpl fileItemBeanImpl = this.getItem(position);
        ((FileListItemHolder)holder).check(fileItemBeanImpl == null ? false : (bl = fileItemBeanImpl.isChecked()));
    }

    @Override
    @Nullable
    public FileItemBeanImpl getItem(int position) {
        if (position >= 0 && position < this.dataList.size() && this.getItemViewType(position) == 10001) {
            return this.dataList.get(position);
        }
        return null;
    }

    public final void setNewData(@Nullable List<FileItemBeanImpl> list) {
        List<FileItemBeanImpl> list2 = list;
        if (list2 != null) {
            List<FileItemBeanImpl> it = list2;
            boolean bl = false;
            this.getDataList().clear();
            this.getDataList().addAll((Collection<FileItemBeanImpl>)it);
            this.notifyDataSetChanged();
        }
    }

    public final void multipleCheckOrNo(@NotNull FileItemBeanImpl item, int position, @NotNull Function0<Boolean> isCanSelect, @NotNull Function0<Unit> checkFailedFunc) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(isCanSelect, (String)"isCanSelect");
        Intrinsics.checkNotNullParameter(checkFailedFunc, (String)"checkFailedFunc");
        boolean $i$f$multipleCheckOrNo = false;
        if (item.isChecked()) {
            this.multipleDisCheck(position);
        } else if (((Boolean)isCanSelect.invoke()).booleanValue()) {
            this.multipleCheck(position);
        } else {
            checkFailedFunc.invoke();
        }
    }

    public final void multipleCheck(int position) {
        FileItemBeanImpl fileItemBeanImpl = this.getItem(position);
        if (fileItemBeanImpl != null) {
            FileItemBeanImpl it = fileItemBeanImpl;
            boolean bl = false;
            it.setCheck(true);
            this.notifyItemChanged(position, true);
        }
    }

    public final void multipleDisCheck(int position) {
        FileItemBeanImpl fileItemBeanImpl = this.getItem(position);
        if (fileItemBeanImpl != null) {
            FileItemBeanImpl it = fileItemBeanImpl;
            boolean bl = false;
            it.setCheck(false);
            this.notifyItemChanged(position, false);
        }
    }

    public final void singleCheck(int position) {
        int n = this.latestChoicePos;
        if (n == -1) {
            FileItemBeanImpl fileItemBeanImpl = this.getItem(position);
            if (fileItemBeanImpl != null) {
                FileItemBeanImpl it = fileItemBeanImpl;
                boolean bl = false;
                it.setCheck(true);
                this.notifyItemChanged(position, true);
            }
            this.latestChoicePos = position;
        } else if (n == position) {
            FileItemBeanImpl fileItemBeanImpl = this.getItem(this.latestChoicePos);
            if (fileItemBeanImpl != null) {
                FileItemBeanImpl it = fileItemBeanImpl;
                boolean bl = false;
                it.setCheck(false);
                this.notifyItemChanged(this.latestChoicePos, false);
            }
            this.latestChoicePos = -1;
        } else {
            FileItemBeanImpl it;
            FileItemBeanImpl fileItemBeanImpl = this.getItem(this.latestChoicePos);
            if (fileItemBeanImpl != null) {
                it = fileItemBeanImpl;
                boolean bl = false;
                it.setCheck(false);
                this.notifyItemChanged(this.latestChoicePos, false);
            }
            this.latestChoicePos = position;
            FileItemBeanImpl fileItemBeanImpl2 = this.getItem(this.latestChoicePos);
            if (fileItemBeanImpl2 != null) {
                it = fileItemBeanImpl2;
                boolean bl = false;
                it.setCheck(true);
                this.notifyItemChanged(this.latestChoicePos, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void disCheckAll() {
        Iterable $this$forEachIndexed$iv = this.dataList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FileItemBeanImpl fileItemBeanImpl = (FileItemBeanImpl)item$iv;
            int index = n;
            boolean bl = false;
            if (FilePickerManager.INSTANCE.getConfig$filepicker_release().isSkipDir() && item.isDir() || !item.isChecked()) continue;
            item.setCheck(false);
            this.getCheckedSet().remove((Object)item);
            FileListAdapterListener fileListAdapterListener = this.listener;
            if (fileListAdapterListener != null) {
                fileListAdapterListener.onCheckSizeChanged(this.getCheckedCount());
            }
            this.notifyItemChanged(index, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkAll() {
        Iterable $this$forEachIndexed$iv = this.dataList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FileItemBeanImpl fileItemBeanImpl = (FileItemBeanImpl)item$iv;
            int index = n;
            boolean bl = false;
            if (this.getCheckedSet().size() >= FilePickerManager.INSTANCE.getConfig$filepicker_release().getMaxSelectable()) {
                return;
            }
            if (FilePickerManager.INSTANCE.getConfig$filepicker_release().isSkipDir() && item.isDir() || item.isChecked()) continue;
            item.setCheck(true);
            this.getCheckedSet().add((Object)item);
            FileListAdapterListener fileListAdapterListener = this.listener;
            if (fileListAdapterListener != null) {
                fileListAdapterListener.onCheckSizeChanged(this.getCheckedCount());
            }
            this.notifyItemChanged(index, true);
        }
    }

    public final void resetCheck() {
        this.getCheckedSet().clear();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lme/rosuh/filepicker/adapter/FileListAdapter$BaseViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lme/rosuh/filepicker/adapter/FileListAdapter;Landroid/view/View;)V", "bind", "", "itemImpl", "Lme/rosuh/filepicker/bean/FileItemBeanImpl;", "position", "", "filepicker_release"})
    public abstract class BaseViewHolder
    extends RecyclerView.ViewHolder {
        public BaseViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)FileListAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
        }

        public abstract void bind(@NotNull FileItemBeanImpl var1, int var2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\tJ(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/rosuh/filepicker/adapter/FileListAdapter$FileListItemHolder;", "Lme/rosuh/filepicker/adapter/FileListAdapter$BaseViewHolder;", "Lme/rosuh/filepicker/adapter/FileListAdapter;", "itemView", "Landroid/view/View;", "(Lme/rosuh/filepicker/adapter/FileListAdapter;Landroid/view/View;)V", "checkBox", "Landroid/widget/CheckBox;", "isSkipDir", "", "ivIcon", "Landroid/widget/ImageView;", "radioButton", "Landroid/widget/RadioButton;", "tvFileName", "Landroid/widget/TextView;", "bind", "", "itemImpl", "Lme/rosuh/filepicker/bean/FileItemBeanImpl;", "position", "", "check", "isCheck", "onCheck", "buttonView", "Landroid/widget/CompoundButton;", "isChecked", "filepicker_release"})
    public final class FileListItemHolder
    extends BaseViewHolder {
        private final boolean isSkipDir;
        @NotNull
        private final TextView tvFileName;
        @NotNull
        private final CheckBox checkBox;
        @NotNull
        private final ImageView ivIcon;
        @NotNull
        private final RadioButton radioButton;

        public FileListItemHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)FileListAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.isSkipDir = FilePickerManager.INSTANCE.getConfig$filepicker_release().isSkipDir();
            View view = itemView.findViewById(R.id.tv_list_file_picker);
            Intrinsics.checkNotNull((Object)view);
            this.tvFileName = (TextView)view;
            View view2 = itemView.findViewById(R.id.cb_list_file_picker);
            Intrinsics.checkNotNull((Object)view2);
            this.checkBox = (CheckBox)view2;
            View view3 = itemView.findViewById(R.id.iv_icon_list_file_picker);
            Intrinsics.checkNotNull((Object)view3);
            this.ivIcon = (ImageView)view3;
            View view4 = itemView.findViewById(R.id.rb_list_file_picker);
            Intrinsics.checkNotNull((Object)view4);
            this.radioButton = (RadioButton)view4;
            int rightId = FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice() ? R.id.rb_list_file_picker : R.id.cb_list_file_picker;
            ViewGroup.LayoutParams layoutParams = this.tvFileName.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)layoutParams;
            params.addRule(0, rightId);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(16, rightId);
            }
            this.tvFileName.setLayoutParams((ViewGroup.LayoutParams)params);
        }

        public final void check(boolean isCheck) {
            if (FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice()) {
                this.radioButton.setChecked(isCheck);
            } else {
                this.checkBox.setChecked(isCheck);
            }
        }

        private final void onCheck(FileItemBeanImpl itemImpl, CompoundButton buttonView, boolean isChecked, int position) {
            if (isChecked) {
                FileListAdapter.this.getCheckedSet().add((Object)itemImpl);
            } else {
                FileListAdapter.this.getCheckedSet().remove((Object)itemImpl);
            }
            itemImpl.setCheck(isChecked);
            FileListAdapterListener fileListAdapterListener = FileListAdapter.this.listener;
            if (fileListAdapterListener != null) {
                fileListAdapterListener.onCheckSizeChanged(FileListAdapter.this.getCheckedCount());
            }
        }

        @Override
        public void bind(@NotNull FileItemBeanImpl itemImpl, int position) {
            CheckBox checkBox;
            Intrinsics.checkNotNullParameter((Object)itemImpl, (String)"itemImpl");
            this.tvFileName.setText((CharSequence)itemImpl.getFileName());
            CheckBox $this$bind_u24lambda_u2d1 = checkBox = this.checkBox;
            boolean bl = false;
            $this$bind_u24lambda_u2d1.setTag((Object)itemImpl);
            $this$bind_u24lambda_u2d1.setVisibility(this.isSkipDir && itemImpl.isDir() || FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice() ? 8 : 0);
            $this$bind_u24lambda_u2d1.setOnCheckedChangeListener((arg_0, arg_1) -> FileListItemHolder.bind$lambda-1$lambda-0($this$bind_u24lambda_u2d1, itemImpl, this, position, arg_0, arg_1));
            $this$bind_u24lambda_u2d1.setChecked(itemImpl.isChecked());
            CheckBox $this$bind_u24lambda_u2d3 = checkBox = this.radioButton;
            boolean bl2 = false;
            $this$bind_u24lambda_u2d3.setTag((Object)itemImpl);
            $this$bind_u24lambda_u2d3.setVisibility(this.isSkipDir && itemImpl.isDir() || !FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice() ? 8 : 0);
            $this$bind_u24lambda_u2d3.setOnCheckedChangeListener((arg_0, arg_1) -> FileListItemHolder.bind$lambda-3$lambda-2((RadioButton)$this$bind_u24lambda_u2d3, itemImpl, this, position, arg_0, arg_1));
            $this$bind_u24lambda_u2d3.setChecked(itemImpl.isChecked());
            if (itemImpl.isDir()) {
                this.ivIcon.setImageResource(R.drawable.ic_folder_file_picker);
            } else {
                FileType fileType = itemImpl.getFileType();
                Integer n = fileType == null ? null : Integer.valueOf(fileType.getFileIconResId());
                int resId = n == null ? R.drawable.ic_unknown_file_picker : n;
                FileType fileType2 = itemImpl.getFileType();
                if (fileType2 instanceof RasterImageFileType ? true : fileType2 instanceof VideoFileType) {
                    ImageLoadController.INSTANCE.load((Context)FileListAdapter.this.context, this.ivIcon, itemImpl.getFilePath(), resId);
                } else {
                    this.ivIcon.setImageResource(resId);
                }
            }
        }

        private static final void bind$lambda-1$lambda-0(CheckBox $this_apply, FileItemBeanImpl $itemImpl, FileListItemHolder this$0, int $position, CompoundButton buttonView, boolean isChecked) {
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)$itemImpl, (String)"$itemImpl");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (!Intrinsics.areEqual((Object)$this_apply.getTag(), (Object)$itemImpl)) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)buttonView, (String)"buttonView");
            this$0.onCheck($itemImpl, buttonView, isChecked, $position);
        }

        private static final void bind$lambda-3$lambda-2(RadioButton $this_apply, FileItemBeanImpl $itemImpl, FileListItemHolder this$0, int $position, CompoundButton buttonView, boolean isChecked) {
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)$itemImpl, (String)"$itemImpl");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (!Intrinsics.areEqual((Object)$this_apply.getTag(), (Object)$itemImpl)) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)buttonView, (String)"buttonView");
            this$0.onCheck($itemImpl, buttonView, isChecked, $position);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/rosuh/filepicker/adapter/FileListAdapter$Companion;", "", "()V", "DEFAULT_FILE_TYPE", "", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

