/*
 * Decompiled with CFR 0.152.
 */
package me.rosuh.filepicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.collection.ArrayMap;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.rosuh.filepicker.FilePickerActivity;
import me.rosuh.filepicker.R;
import me.rosuh.filepicker.adapter.BaseAdapter;
import me.rosuh.filepicker.adapter.FileListAdapter;
import me.rosuh.filepicker.adapter.FileNavAdapter;
import me.rosuh.filepicker.adapter.RecyclerViewListener;
import me.rosuh.filepicker.bean.FileBean;
import me.rosuh.filepicker.bean.FileItemBeanImpl;
import me.rosuh.filepicker.bean.FileNavBeanImpl;
import me.rosuh.filepicker.config.FileItemOnClickListener;
import me.rosuh.filepicker.config.FilePickerConfig;
import me.rosuh.filepicker.config.FilePickerManager;
import me.rosuh.filepicker.config.ItemClickListener;
import me.rosuh.filepicker.utils.FileListAdapterListenerBuilder;
import me.rosuh.filepicker.utils.FileUtils;
import me.rosuh.filepicker.utils.ScreenUtilsKt;
import me.rosuh.filepicker.widget.PosLinearLayoutManager;
import me.rosuh.filepicker.widget.RecyclerViewFilePicker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\b\u0007\u0018\u0000 t2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001tB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0014\u0010I\u001a\u0004\u0018\u00010\u00162\b\u0010J\u001a\u0004\u0018\u00010=H\u0002J8\u0010K\u001a\u00020F2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020M00j\b\u0012\u0004\u0012\u00020M`22\u0016\u0010N\u001a\u0012\u0012\u0004\u0012\u00020100j\b\u0012\u0004\u0012\u000201`2H\u0002J\b\u0010O\u001a\u00020FH\u0002J\b\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u00020QH\u0002J\b\u0010S\u001a\u00020FH\u0002J\u0010\u0010T\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010U\u001a\u00020FH\u0016J\u0012\u0010V\u001a\u00020F2\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\u0012\u0010Y\u001a\u00020F2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0014J\b\u0010\\\u001a\u00020FH\u0014J&\u0010]\u001a\u00020F2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_2\u0006\u0010a\u001a\u00020X2\u0006\u0010b\u001a\u00020\rH\u0016J&\u0010c\u001a\u00020F2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_2\u0006\u0010a\u001a\u00020X2\u0006\u0010b\u001a\u00020\rH\u0016J&\u0010d\u001a\u00020F2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_2\u0006\u0010a\u001a\u00020X2\u0006\u0010b\u001a\u00020\rH\u0016J-\u0010e\u001a\u00020F2\u0006\u0010f\u001a\u00020\r2\u000e\u0010g\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0h2\u0006\u0010i\u001a\u00020jH\u0016\u00a2\u0006\u0002\u0010kJ\b\u0010l\u001a\u00020FH\u0002J\b\u0010m\u001a\u00020FH\u0002J\u001a\u0010n\u001a\u00020F2\b\u0010o\u001a\u0004\u0018\u0001012\u0006\u0010b\u001a\u00020\rH\u0002J\b\u0010p\u001a\u00020FH\u0002J\u0010\u0010q\u001a\u00020F2\u0006\u0010r\u001a\u00020QH\u0002J\b\u0010s\u001a\u00020FH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0011\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0011\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010*\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0011\u001a\u0004\b,\u0010-R\u001e\u0010/\u001a\u0012\u0012\u0004\u0012\u00020100j\b\u0012\u0004\u0012\u000201`2X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00103\u001a\u0004\u0018\u00010\u00168BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0018R\u001b\u00105\u001a\u0002068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u0011\u001a\u0004\b7\u00108R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lme/rosuh/filepicker/FilePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Landroid/view/View$OnClickListener;", "Lme/rosuh/filepicker/adapter/RecyclerViewListener$OnItemClickListener;", "()V", "btnConfirm", "Landroid/widget/Button;", "btnGoBack", "Landroid/widget/ImageView;", "btnSelectedAll", "currOffsetMap", "Landroidx/collection/ArrayMap;", "", "", "getCurrOffsetMap", "()Landroidx/collection/ArrayMap;", "currOffsetMap$delegate", "Lkotlin/Lazy;", "currPosMap", "getCurrPosMap", "currPosMap$delegate", "fileListListener", "Lme/rosuh/filepicker/adapter/RecyclerViewListener;", "getFileListListener", "()Lme/rosuh/filepicker/adapter/RecyclerViewListener;", "listAdapter", "Lme/rosuh/filepicker/adapter/FileListAdapter;", "getListAdapter", "()Lme/rosuh/filepicker/adapter/FileListAdapter;", "listAdapter$delegate", "loadFileRunnable", "Ljava/lang/Runnable;", "getLoadFileRunnable", "()Ljava/lang/Runnable;", "loadFileRunnable$delegate", "loadingFuture", "Ljava/util/concurrent/Future;", "loadingThreadPool", "Ljava/util/concurrent/ExecutorService;", "mainHandler", "Landroid/os/Handler;", "maxSelectable", "navAdapter", "Lme/rosuh/filepicker/adapter/FileNavAdapter;", "getNavAdapter", "()Lme/rosuh/filepicker/adapter/FileNavAdapter;", "navAdapter$delegate", "navDataSource", "Ljava/util/ArrayList;", "Lme/rosuh/filepicker/bean/FileNavBeanImpl;", "Lkotlin/collections/ArrayList;", "navListener", "getNavListener", "pickerConfig", "Lme/rosuh/filepicker/config/FilePickerConfig;", "getPickerConfig", "()Lme/rosuh/filepicker/config/FilePickerConfig;", "pickerConfig$delegate", "rvList", "Lme/rosuh/filepicker/widget/RecyclerViewFilePicker;", "rvNav", "Landroidx/recyclerview/widget/RecyclerView;", "selectedCount", "getSelectedCount", "()I", "srl", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "tvToolbarTitle", "Landroid/widget/TextView;", "enterDirAndUpdateUI", "", "fileBean", "Lme/rosuh/filepicker/bean/FileBean;", "getListener", "recyclerView", "initRv", "listData", "Lme/rosuh/filepicker/bean/FileItemBeanImpl;", "navDataList", "initView", "isCanSelect", "", "isPermissionGrated", "loadList", "notifyDataChangedForList", "onBackPressed", "onClick", "v", "Landroid/view/View;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onItemChildClick", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "position", "onItemClick", "onItemLongClick", "onRequestPermissionsResult", "requestCode", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "requestPermission", "resetViewState", "saveCurrPos", "item", "setLoadingFinish", "switchButton", "isEnable", "updateItemUI", "Companion", "filepicker_release"})
@SuppressLint(value={"ShowToast"})
public final class FilePickerActivity
extends AppCompatActivity
implements View.OnClickListener,
RecyclerViewListener.OnItemClickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RecyclerViewFilePicker rvList;
    @Nullable
    private RecyclerView rvNav;
    @Nullable
    private SwipeRefreshLayout srl;
    @Nullable
    private TextView tvToolbarTitle;
    @Nullable
    private Button btnConfirm;
    @Nullable
    private Button btnSelectedAll;
    @Nullable
    private ImageView btnGoBack;
    @NotNull
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private final ExecutorService loadingThreadPool;
    @Nullable
    private Future<?> loadingFuture;
    @NotNull
    private final Lazy loadFileRunnable$delegate;
    @NotNull
    private final Lazy listAdapter$delegate;
    @NotNull
    private final Lazy navAdapter$delegate;
    @NotNull
    private ArrayList<FileNavBeanImpl> navDataSource;
    private final int maxSelectable;
    @NotNull
    private final Lazy pickerConfig$delegate;
    @Nullable
    private RecyclerViewListener fileListListener;
    @Nullable
    private RecyclerViewListener navListener;
    @NotNull
    private final Lazy currPosMap$delegate;
    @NotNull
    private final Lazy currOffsetMap$delegate;
    @NotNull
    private static final String TAG = "FilePickerActivity";
    private static final int FILE_PICKER_PERMISSION_REQUEST_CODE = 10201;
    private static final long KEEP_ALIVE_TIME = 10L;

    public FilePickerActivity() {
        ExecutorService executorService = FilePickerManager.INSTANCE.getConfig$filepicker_release().getThreadPool$filepicker_release();
        if (executorService == null) {
            executorService = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.MINUTES, new LinkedBlockingDeque());
        }
        this.loadingThreadPool = executorService;
        this.loadFileRunnable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Runnable>(this){
            final /* synthetic */ FilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Runnable invoke() {
                return () -> loadFileRunnable.2.invoke$lambda-1(this.this$0);
            }

            private static final void invoke$lambda-1$lambda-0(FilePickerActivity this$0, ArrayList $listData) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$listData, (String)"$listData");
                FilePickerActivity.access$initRv(this$0, $listData, FilePickerActivity.access$getNavDataSource$p(this$0));
                FilePickerActivity.access$setLoadingFinish(this$0);
            }

            private static final void invoke$lambda-1(FilePickerActivity this$0) {
                File file;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                File customRootPathFile = FilePickerActivity.access$getPickerConfig(this$0).getCustomRootPathFile$filepicker_release();
                File file2 = customRootPathFile;
                if (file2 == null ? false : file2.exists()) {
                    CharSequence charSequence;
                    FilePickerActivity.access$getNavDataSource$p(this$0).clear();
                    File root = FileUtils.Companion.getRootFile();
                    String curPath = customRootPathFile.getAbsolutePath();
                    while (!Intrinsics.areEqual((Object)curPath, (Object)root.getParent()) && !((charSequence = (CharSequence)curPath) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                        Log.i((String)"loadFileRunnable", (String)Intrinsics.stringPlus((String)"curPath = ", (Object)curPath));
                        File f = new File(curPath);
                        String string2 = FileUtils.Companion.getDirAlias(f);
                        String string3 = f.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"f.absolutePath");
                        FileNavBeanImpl fileNavBeanImpl = new FileNavBeanImpl(string2, string3);
                        FilePickerActivity.access$getNavDataSource$p(this$0).add(0, fileNavBeanImpl);
                        curPath = f.getParent();
                    }
                    FilePickerActivity.access$getPickerConfig(this$0).resetCustomFile();
                    file = customRootPathFile;
                } else {
                    file = FilePickerActivity.access$getNavDataSource$p(this$0).isEmpty() && FilePickerActivity.access$getPickerConfig(this$0).isSkipDir() ? FileUtils.Companion.getRootFile() : (FilePickerActivity.access$getNavDataSource$p(this$0).isEmpty() && !FilePickerActivity.access$getPickerConfig(this$0).isSkipDir() ? FileUtils.Companion.getRootFile().getParentFile() : new File(((FileNavBeanImpl)CollectionsKt.last((List)FilePickerActivity.access$getNavDataSource$p(this$0))).getDirPath()));
                }
                File rootFile = file;
                Intrinsics.checkNotNullExpressionValue((Object)rootFile, (String)"rootFile");
                ArrayList<FileItemBeanImpl> listData = FileUtils.Companion.produceListDataSource(rootFile);
                ArrayList arrayList = FilePickerActivity.access$getNavDataSource$p(this$0);
                String string4 = FilePickerActivity.access$getNavDataSource$p(this$0).isEmpty() ? rootFile.getPath() : ((FileNavBeanImpl)CollectionsKt.last((List)FilePickerActivity.access$getNavDataSource$p(this$0))).getDirPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"if (navDataSource.isEmpt\u2026dirPath\n                }");
                FilePickerActivity.access$setNavDataSource$p(this$0, FileUtils.Companion.produceNavDataSource(arrayList, string4, (Context)this$0));
                FilePickerActivity.access$getMainHandler$p(this$0).post(() -> loadFileRunnable.2.invoke$lambda-1$lambda-0(this$0, listData));
            }
        }));
        this.listAdapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FileListAdapter>(this){
            final /* synthetic */ FilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FileListAdapter invoke() {
                FileListAdapter fileListAdapter = new FileListAdapter(this.this$0, FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice());
                FilePickerActivity filePickerActivity = this.this$0;
                FileListAdapter $this$invoke_u24lambda_u2d0 = fileListAdapter;
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.addListener((Function1<? super FileListAdapterListenerBuilder, Unit>)((Function1)new Function1<FileListAdapterListenerBuilder, Unit>(filePickerActivity){
                    final /* synthetic */ FilePickerActivity this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull FileListAdapterListenerBuilder $this$addListener) {
                        Intrinsics.checkNotNullParameter((Object)$this$addListener, (String)"$this$addListener");
                        $this$addListener.onCheckSizeChanged((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this.this$0){
                            final /* synthetic */ FilePickerActivity this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(int it) {
                                FilePickerActivity.access$updateItemUI(this.this$0);
                            }
                        }));
                    }
                }));
                return fileListAdapter;
            }
        }));
        this.navAdapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FileNavAdapter>(this){
            final /* synthetic */ FilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FileNavAdapter invoke() {
                return new FileNavAdapter(this.this$0);
            }
        }));
        this.navDataSource = new ArrayList();
        this.maxSelectable = FilePickerManager.INSTANCE.getConfig$filepicker_release().getMaxSelectable();
        this.pickerConfig$delegate = LazyKt.lazy((Function0)pickerConfig.2.INSTANCE);
        this.currPosMap$delegate = LazyKt.lazy((Function0)currPosMap.2.INSTANCE);
        this.currOffsetMap$delegate = LazyKt.lazy((Function0)currOffsetMap.2.INSTANCE);
    }

    private final Runnable getLoadFileRunnable() {
        Lazy lazy = this.loadFileRunnable$delegate;
        return (Runnable)lazy.getValue();
    }

    private final FileListAdapter getListAdapter() {
        Lazy lazy = this.listAdapter$delegate;
        return (FileListAdapter)((Object)lazy.getValue());
    }

    private final FileNavAdapter getNavAdapter() {
        Lazy lazy = this.navAdapter$delegate;
        return (FileNavAdapter)((Object)lazy.getValue());
    }

    private final int getSelectedCount() {
        return this.getListAdapter().getCheckedCount();
    }

    private final FilePickerConfig getPickerConfig() {
        Lazy lazy = this.pickerConfig$delegate;
        return (FilePickerConfig)lazy.getValue();
    }

    private final RecyclerViewListener getFileListListener() {
        if (this.fileListListener == null) {
            this.fileListListener = this.getListener(this.rvList);
        }
        return this.fileListListener;
    }

    private final RecyclerViewListener getNavListener() {
        if (this.navListener == null) {
            this.navListener = this.getListener(this.rvNav);
        }
        return this.navListener;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(this.getPickerConfig().getThemeId());
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.main_activity_for_file_picker);
        this.initView();
        if (this.isPermissionGrated()) {
            this.loadList();
        } else {
            this.requestPermission();
        }
    }

    protected void onDestroy() {
        boolean shouldShutDownThreadPool;
        super.onDestroy();
        Log.i((String)TAG, (String)"onDestroy");
        try {
            Future<?> future = this.loadingFuture;
            if (future != null) {
                future.cancel(true);
            }
            this.loadingFuture = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onDestroy: ", (Throwable)e);
        }
        boolean bl = shouldShutDownThreadPool = !Intrinsics.areEqual((Object)this.getPickerConfig().getThreadPool$filepicker_release(), (Object)this.loadingThreadPool) || this.getPickerConfig().getThreadPoolAutoShutDown$filepicker_release();
        if (!this.loadingThreadPool.isShutdown() && shouldShutDownThreadPool) {
            Log.i((String)TAG, (String)"shutdown thread pool");
            this.loadingThreadPool.shutdown();
        }
        this.getCurrOffsetMap().clear();
        this.getCurrPosMap().clear();
    }

    private final boolean isPermissionGrated() {
        return ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    private final void requestPermission() {
        String[] stringArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
        ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])stringArray, (int)10201);
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 10201) {
            if (grantResults.length == 0 || grantResults[0] != 0) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.file_picker_request_permission_failed), (int)0).show();
                this.setLoadingFinish();
            } else {
                this.loadList();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initView() {
        void $this$initView_u24lambda_u2d9;
        RecyclerViewFilePicker $this$initView_u24lambda_u2d7;
        int[] nArray;
        RelativeLayout.LayoutParams layoutParams;
        String it;
        Button button;
        ImageView imageView = this.btnGoBack = (ImageView)this.findViewById(R.id.btn_go_back_file_picker);
        if (imageView != null) {
            imageView.setOnClickListener((View.OnClickListener)this);
        }
        Button button2 = this.btnSelectedAll = (Button)this.findViewById(R.id.btn_selected_all_file_picker);
        if (button2 != null) {
            Button $this$initView_u24lambda_u2d1 = button = button2;
            boolean bl = false;
            if (this.getPickerConfig().getSingleChoice()) {
                $this$initView_u24lambda_u2d1.setVisibility(8);
            } else {
                $this$initView_u24lambda_u2d1.setOnClickListener((View.OnClickListener)this);
                it = FilePickerManager.INSTANCE.getConfig$filepicker_release().getSelectAllText();
                boolean bl2 = false;
                $this$initView_u24lambda_u2d1.setText((CharSequence)it);
            }
        }
        Button button3 = this.btnConfirm = (Button)this.findViewById(R.id.btn_confirm_file_picker);
        if (button3 != null) {
            Button $this$initView_u24lambda_u2d4 = button = button3;
            boolean bl = false;
            if (Build.VERSION.SDK_INT <= 19) {
                void $this$initView_u24lambda_u2d4_u24lambda_u2d2;
                layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                it = layoutParams;
                Button bl2 = $this$initView_u24lambda_u2d4;
                boolean bl3 = false;
                $this$initView_u24lambda_u2d4_u24lambda_u2d2.addRule(11);
                $this$initView_u24lambda_u2d4_u24lambda_u2d2.addRule(15);
                $this$initView_u24lambda_u2d4_u24lambda_u2d2.setMargins(0, 0, ScreenUtilsKt.getDp(16), 0);
                bl2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            $this$initView_u24lambda_u2d4.setOnClickListener((View.OnClickListener)this);
            it = FilePickerManager.INSTANCE.getConfig$filepicker_release().getConfirmText();
            boolean bl4 = false;
            $this$initView_u24lambda_u2d4.setText((CharSequence)it);
        }
        TextView textView = this.tvToolbarTitle = (TextView)this.findViewById(R.id.tv_toolbar_title_file_picker);
        if (textView != null) {
            textView.setVisibility(this.getPickerConfig().getSingleChoice() ? 8 : 0);
        }
        SwipeRefreshLayout swipeRefreshLayout = this.srl = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
        if (swipeRefreshLayout != null) {
            Button $this$initView_u24lambda_u2d6 = button = swipeRefreshLayout;
            boolean bl = false;
            $this$initView_u24lambda_u2d6.setOnRefreshListener(() -> FilePickerActivity.initView$lambda-6$lambda-5(this));
            $this$initView_u24lambda_u2d6.setRefreshing(true);
            int n = this.getPickerConfig().getThemeId();
            nArray = $this$initView_u24lambda_u2d6.getResources().getIntArray(n == R.style.FilePickerThemeCrane ? R.array.crane_swl_colors : (n == R.style.FilePickerThemeReply ? R.array.reply_swl_colors : (n == R.style.FilePickerThemeShrine ? R.array.shrine_swl_colors : R.array.rail_swl_colors)));
            $this$initView_u24lambda_u2d6.setColorSchemeColors(Arrays.copyOf(nArray, nArray.length));
        }
        View view = this.findViewById(R.id.rv_nav_file_picker);
        button = (RecyclerView)view;
        FilePickerActivity filePickerActivity = this;
        boolean bl = false;
        $this$initView_u24lambda_u2d7.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        $this$initView_u24lambda_u2d7.setAdapter(this.getNavAdapter());
        filePickerActivity.rvNav = (RecyclerView)view;
        view = this.findViewById(R.id.rv_list_file_picker);
        $this$initView_u24lambda_u2d7 = (RecyclerViewFilePicker)view;
        filePickerActivity = this;
        boolean bl5 = false;
        $this$initView_u24lambda_u2d9.setHasFixedSize(true);
        $this$initView_u24lambda_u2d9.setAdapter(this.getListAdapter());
        $this$initView_u24lambda_u2d9.setLayoutAnimation(AnimationUtils.loadLayoutAnimation((Context)$this$initView_u24lambda_u2d9.getContext(), (int)R.anim.layout_item_anim_file_picker));
        $this$initView_u24lambda_u2d9.setLayoutManager((RecyclerView.LayoutManager)new PosLinearLayoutManager((Context)this));
        if (!$this$initView_u24lambda_u2d9.hasEmptyView()) {
            void $this$initView_u24lambda_u2d9_u24lambda_u2d8;
            View view2 = LayoutInflater.from((Context)$this$initView_u24lambda_u2d9.getContext()).inflate(R.layout.empty_file_list_file_picker, (ViewGroup)$this$initView_u24lambda_u2d9, false);
            layoutParams = view2;
            nArray = $this$initView_u24lambda_u2d9;
            boolean bl6 = false;
            ((TextView)$this$initView_u24lambda_u2d9_u24lambda_u2d8.findViewById(R.id.tv_empty_list)).setText((CharSequence)this.getPickerConfig().getEmptyListTips());
            nArray.setEmptyView(view2);
        }
        filePickerActivity.rvList = (RecyclerViewFilePicker)view;
    }

    private final void loadList() {
        if (!this.isPermissionGrated()) {
            this.requestPermission();
            return;
        }
        if (!Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted")) {
            Log.e((String)TAG, (String)"External storage is not available ====>>> Environment.getExternalStorageState() != MEDIA_MOUNTED");
            return;
        }
        try {
            Log.i((String)TAG, (String)("loadList in " + Thread.currentThread() + " in " + this.loadingThreadPool));
            this.loadingFuture = this.loadingThreadPool.submit(this.getLoadFileRunnable());
        }
        catch (RejectedExecutionException e) {
            Log.e((String)TAG, (String)"submit job failed");
        }
    }

    private final void initRv(ArrayList<FileItemBeanImpl> listData, ArrayList<FileNavBeanImpl> navDataList) {
        FileListAdapter fileListAdapter;
        RecyclerViewListener it;
        RecyclerView recyclerView;
        this.switchButton(true);
        this.getNavAdapter().setNewData((List<FileNavBeanImpl>)navDataList);
        RecyclerView recyclerView2 = this.rvNav;
        if (recyclerView2 != null) {
            RecyclerView $this$initRv_u24lambda_u2d12 = recyclerView = recyclerView2;
            boolean bl = false;
            RecyclerViewListener recyclerViewListener = this.getNavListener();
            if (recyclerViewListener != null) {
                it = recyclerViewListener;
                boolean bl2 = false;
                $this$initRv_u24lambda_u2d12.removeOnItemTouchListener((RecyclerView.OnItemTouchListener)it);
            }
            RecyclerViewListener recyclerViewListener2 = this.getNavListener();
            if (recyclerViewListener2 != null) {
                it = recyclerViewListener2;
                boolean bl3 = false;
                $this$initRv_u24lambda_u2d12.addOnItemTouchListener((RecyclerView.OnItemTouchListener)it);
            }
        }
        FileListAdapter $this$initRv_u24lambda_u2d13 = fileListAdapter = this.getListAdapter();
        boolean bl = false;
        $this$initRv_u24lambda_u2d13.setSingleChoice(FilePickerManager.INSTANCE.getConfig$filepicker_release().getSingleChoice());
        $this$initRv_u24lambda_u2d13.setNewData((List<FileItemBeanImpl>)listData);
        RecyclerViewFilePicker recyclerViewFilePicker = this.rvList;
        if (recyclerViewFilePicker != null) {
            RecyclerView $this$initRv_u24lambda_u2d16 = recyclerView = recyclerViewFilePicker;
            boolean bl4 = false;
            RecyclerViewListener recyclerViewListener = this.getFileListListener();
            if (recyclerViewListener != null) {
                it = recyclerViewListener;
                boolean bl5 = false;
                $this$initRv_u24lambda_u2d16.removeOnItemTouchListener((RecyclerView.OnItemTouchListener)it);
            }
            RecyclerViewListener recyclerViewListener3 = this.getFileListListener();
            if (recyclerViewListener3 != null) {
                it = recyclerViewListener3;
                boolean bl6 = false;
                $this$initRv_u24lambda_u2d16.addOnItemTouchListener((RecyclerView.OnItemTouchListener)it);
            }
        }
    }

    private final void setLoadingFinish() {
        SwipeRefreshLayout swipeRefreshLayout = this.srl;
        if (swipeRefreshLayout != null) {
            swipeRefreshLayout.setRefreshing(false);
        }
    }

    private final RecyclerViewListener getListener(RecyclerView recyclerView) {
        if (recyclerView == null) {
            return null;
        }
        return new RecyclerViewListener(recyclerView, this);
    }

    private final ArrayMap<String, Integer> getCurrPosMap() {
        Lazy lazy = this.currPosMap$delegate;
        return (ArrayMap)lazy.getValue();
    }

    private final ArrayMap<String, Integer> getCurrOffsetMap() {
        Lazy lazy = this.currOffsetMap$delegate;
        return (ArrayMap)lazy.getValue();
    }

    private final void saveCurrPos(FileNavBeanImpl item, int position) {
        FileNavBeanImpl fileNavBeanImpl = item;
        if (fileNavBeanImpl != null) {
            FileNavBeanImpl $this$saveCurrPos_u24lambda_u2d18 = fileNavBeanImpl;
            boolean bl = false;
            Map map = (Map)this.getCurrPosMap();
            String string2 = $this$saveCurrPos_u24lambda_u2d18.getFilePath();
            Integer n = position;
            map.put(string2, n);
            RecyclerViewFilePicker recyclerViewFilePicker = this.rvList;
            string2 = recyclerViewFilePicker == null ? null : recyclerViewFilePicker.getLayoutManager();
            LinearLayoutManager linearLayoutManager = string2 instanceof LinearLayoutManager ? (LinearLayoutManager)string2 : null;
            if (linearLayoutManager != null) {
                int n2;
                LinearLayoutManager it = linearLayoutManager;
                boolean bl2 = false;
                View view = it.findViewByPosition(position);
                Integer cfr_ignored_0 = (Integer)this.getCurrOffsetMap().put((Object)$this$saveCurrPos_u24lambda_u2d18.getFilePath(), (Object)(view == null ? 0 : (n2 = view.getTop())));
            }
        }
    }

    @Override
    public void onItemClick(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter, @NotNull View view, int position) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        FileBean item = ((BaseAdapter)adapter).getItem(position);
        if (item == null) {
            return;
        }
        File file = new File(item.getFilePath());
        if (!file.exists()) {
            return;
        }
        int n = view.getId();
        if (n == R.id.item_list_file_picker) {
            boolean hookItemClick;
            ItemClickListener itemClickListener = FilePickerManager.INSTANCE.getConfig$filepicker_release().getItemClickListener();
            boolean bl = itemClickListener == null ? false : (hookItemClick = itemClickListener.onItemClick((FileListAdapter)adapter, view, position));
            if (hookItemClick) {
                return;
            }
            if (file.isDirectory()) {
                RecyclerView recyclerView = this.rvNav;
                RecyclerView.Adapter adapter2 = recyclerView == null ? null : recyclerView.getAdapter();
                FileNavAdapter fileNavAdapter = adapter2 instanceof FileNavAdapter ? (FileNavAdapter)adapter2 : null;
                if (fileNavAdapter != null) {
                    FileNavAdapter it = fileNavAdapter;
                    boolean bl2 = false;
                    this.saveCurrPos((FileNavBeanImpl)CollectionsKt.last((List)it.getDataList()), position);
                }
                this.enterDirAndUpdateUI(item);
            } else {
                FileItemOnClickListener fileItemOnClickListener = FilePickerManager.INSTANCE.getConfig$filepicker_release().getFileItemOnClickListener();
                if (fileItemOnClickListener != null) {
                    fileItemOnClickListener.onItemClick((FileListAdapter)adapter, view, position);
                }
            }
        } else if (n == R.id.item_nav_file_picker && file.isDirectory()) {
            RecyclerView recyclerView = this.rvNav;
            RecyclerView.Adapter adapter3 = recyclerView == null ? null : recyclerView.getAdapter();
            FileNavAdapter fileNavAdapter = adapter3 instanceof FileNavAdapter ? (FileNavAdapter)adapter3 : null;
            if (fileNavAdapter != null) {
                FileNavAdapter it = fileNavAdapter;
                boolean bl = false;
                this.saveCurrPos((FileNavBeanImpl)CollectionsKt.last((List)it.getDataList()), position);
            }
            this.enterDirAndUpdateUI(item);
        }
    }

    @Override
    public void onItemChildClick(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter, @NotNull View view, int position) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getId() == R.id.tv_btn_nav_file_picker) {
            FileNavBeanImpl item = ((FileNavAdapter)adapter).getItem(position);
            if (item == null) {
                return;
            }
            this.enterDirAndUpdateUI(item);
        } else {
            boolean hookItemClick;
            FileItemBeanImpl fileItemBeanImpl = ((FileListAdapter)adapter).getItem(position);
            if (fileItemBeanImpl == null) {
                return;
            }
            FileItemBeanImpl item = fileItemBeanImpl;
            ItemClickListener itemClickListener = FilePickerManager.INSTANCE.getConfig$filepicker_release().getItemClickListener();
            boolean bl = itemClickListener == null ? false : (hookItemClick = itemClickListener.onItemChildClick((FileListAdapter)adapter, view, position));
            if (hookItemClick) {
                return;
            }
            if (item.isDir() && this.getPickerConfig().isSkipDir()) {
                this.enterDirAndUpdateUI(item);
                return;
            }
            if (this.getPickerConfig().getSingleChoice()) {
                this.getListAdapter().singleCheck(position);
            } else {
                FileListAdapter this_$iv = this.getListAdapter();
                boolean $i$f$multipleCheckOrNo = false;
                if (item.isChecked()) {
                    this_$iv.multipleDisCheck(position);
                } else {
                    boolean bl2 = false;
                    if (this.isCanSelect()) {
                        this_$iv.multipleCheck(position);
                    } else {
                        boolean bl3 = false;
                        Object[] objectArray = new Object[]{this.maxSelectable};
                        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(this.getPickerConfig().getMaxSelectCountTips(), objectArray), (int)0).show();
                    }
                }
            }
        }
    }

    @Override
    public void onItemLongClick(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter, @NotNull View view, int position) {
        boolean hookItemClick;
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getId() != R.id.item_list_file_picker) {
            return;
        }
        FileItemBeanImpl fileItemBeanImpl = ((FileListAdapter)adapter).getItem(position);
        if (fileItemBeanImpl == null) {
            return;
        }
        FileItemBeanImpl item = fileItemBeanImpl;
        ItemClickListener itemClickListener = FilePickerManager.INSTANCE.getConfig$filepicker_release().getItemClickListener();
        boolean bl = itemClickListener == null ? false : (hookItemClick = itemClickListener.onItemLongClick((FileListAdapter)adapter, view, position));
        if (hookItemClick) {
            return;
        }
        File file = new File(item.getFilePath());
        boolean isSkipDir = FilePickerManager.INSTANCE.getConfig$filepicker_release().isSkipDir();
        if (file.exists() && file.isDirectory() && isSkipDir) {
            return;
        }
        if (item.isDir() && this.getPickerConfig().isSkipDir()) {
            this.enterDirAndUpdateUI(item);
            return;
        }
        if (this.getPickerConfig().getSingleChoice()) {
            this.getListAdapter().singleCheck(position);
        } else {
            FileListAdapter this_$iv = this.getListAdapter();
            boolean $i$f$multipleCheckOrNo = false;
            if (item.isChecked()) {
                this_$iv.multipleDisCheck(position);
            } else {
                boolean bl2 = false;
                if (this.isCanSelect()) {
                    this_$iv.multipleCheck(position);
                } else {
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{this.maxSelectable};
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(this.getPickerConfig().getMaxSelectCountTips(), objectArray), (int)0).show();
                }
            }
        }
        FileItemOnClickListener fileItemOnClickListener = FilePickerManager.INSTANCE.getConfig$filepicker_release().getFileItemOnClickListener();
        if (fileItemOnClickListener != null) {
            fileItemOnClickListener.onItemLongClick((FileListAdapter)adapter, view, position);
        }
    }

    private final void enterDirAndUpdateUI(FileBean fileBean) {
        this.resetViewState();
        File nextFiles = new File(fileBean.getFilePath());
        this.getListAdapter().setNewData((List<FileItemBeanImpl>)FileUtils.Companion.produceListDataSource(nextFiles));
        this.navDataSource = FileUtils.Companion.produceNavDataSource(new ArrayList<FileNavBeanImpl>((Collection)this.getNavAdapter().getDataList()), fileBean.getFilePath(), (Context)this);
        this.getNavAdapter().setNewData((List<FileNavBeanImpl>)this.navDataSource);
        RecyclerView recyclerView = this.rvNav;
        if (recyclerView != null) {
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            if (adapter != null) {
                int n;
                int it = n = adapter.getItemCount();
                boolean bl = false;
                RecyclerView recyclerView2 = this.rvNav;
                if (recyclerView2 != null) {
                    recyclerView2.smoothScrollToPosition(it == 0 ? 0 : it - 1);
                }
            }
        }
        this.notifyDataChangedForList(fileBean);
    }

    private final void notifyDataChangedForList(FileBean fileBean) {
        RecyclerViewFilePicker recyclerViewFilePicker = this.rvList;
        if (recyclerViewFilePicker != null) {
            RecyclerViewFilePicker recyclerViewFilePicker2;
            RecyclerViewFilePicker $this$notifyDataChangedForList_u24lambda_u2d25 = recyclerViewFilePicker2 = recyclerViewFilePicker;
            boolean bl = false;
            RecyclerView.LayoutManager layoutManager = $this$notifyDataChangedForList_u24lambda_u2d25.getLayoutManager();
            PosLinearLayoutManager posLinearLayoutManager = layoutManager instanceof PosLinearLayoutManager ? (PosLinearLayoutManager)layoutManager : null;
            if (posLinearLayoutManager != null) {
                Integer n = (Integer)this.getCurrPosMap().get((Object)fileBean.getFilePath());
                Integer n2 = (Integer)this.getCurrOffsetMap().get((Object)fileBean.getFilePath());
                posLinearLayoutManager.setTargetPos(n == null ? 0 : n, n2 == null ? 0 : n2);
            }
            $this$notifyDataChangedForList_u24lambda_u2d25.scheduleLayoutAnimation();
        }
    }

    private final void switchButton(boolean isEnable) {
        Button button = this.btnConfirm;
        if (button != null) {
            button.setEnabled(isEnable);
        }
        Button button2 = this.btnSelectedAll;
        if (button2 != null) {
            button2.setEnabled(isEnable);
        }
    }

    private final void resetViewState() {
        this.getListAdapter().resetCheck();
        this.updateItemUI();
    }

    private final void updateItemUI() {
        if (this.getPickerConfig().getSingleChoice()) {
            return;
        }
        if (this.getSelectedCount() == 0) {
            Button button = this.btnSelectedAll;
            if (button != null) {
                button.setText((CharSequence)this.getPickerConfig().getSelectAllText());
            }
            TextView textView = this.tvToolbarTitle;
            if (textView != null) {
                textView.setText((CharSequence)"");
            }
            return;
        }
        Button button = this.btnSelectedAll;
        if (button != null) {
            button.setText((CharSequence)this.getPickerConfig().getDeSelectAllText());
        }
        TextView textView = this.tvToolbarTitle;
        if (textView != null) {
            Object[] objectArray = new Object[]{this.getSelectedCount()};
            textView.setText((CharSequence)this.getResources().getString(this.getPickerConfig().getHadSelectedText(), objectArray));
        }
    }

    public void onBackPressed() {
        int n;
        RecyclerView recyclerView = this.rvNav;
        RecyclerView.Adapter adapter = recyclerView == null ? null : recyclerView.getAdapter();
        FileNavAdapter fileNavAdapter = adapter instanceof FileNavAdapter ? (FileNavAdapter)adapter : null;
        if ((fileNavAdapter == null ? 0 : (n = fileNavAdapter.getItemCount())) <= 1) {
            super.onBackPressed();
        } else {
            RecyclerView recyclerView2 = this.rvNav;
            adapter = recyclerView2 == null ? null : recyclerView2.getAdapter();
            FileNavAdapter fileNavAdapter2 = adapter instanceof FileNavAdapter ? (FileNavAdapter)adapter : null;
            if (fileNavAdapter2 != null) {
                FileNavAdapter $this$onBackPressed_u24lambda_u2d26 = fileNavAdapter2;
                boolean bl = false;
                FileNavBeanImpl fileNavBeanImpl = $this$onBackPressed_u24lambda_u2d26.getItem($this$onBackPressed_u24lambda_u2d26.getItemCount() - 2);
                Intrinsics.checkNotNull((Object)fileNavBeanImpl);
                this.enterDirAndUpdateUI(fileNavBeanImpl);
            }
        }
    }

    public void onClick(@Nullable View v) {
        View view = v;
        Intrinsics.checkNotNull((Object)view);
        int n = view.getId();
        if (n == R.id.btn_selected_all_file_picker) {
            if (this.getSelectedCount() > 0) {
                this.getListAdapter().disCheckAll();
            } else if (this.isCanSelect()) {
                this.getListAdapter().checkAll();
            }
        } else if (n == R.id.btn_confirm_file_picker) {
            Collection collection = this.getListAdapter().getDataList();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            Intent intent = new Intent();
            for (FileItemBeanImpl data : this.getListAdapter().getDataList()) {
                if (!data.isChecked()) continue;
                list.add(data.getFilePath());
            }
            if (list.isEmpty()) {
                this.setResult(0, intent);
                this.finish();
            }
            FilePickerManager.INSTANCE.saveData$filepicker_release((List<String>)list);
            this.setResult(-1, intent);
            this.finish();
        } else if (n == R.id.btn_go_back_file_picker) {
            this.onBackPressed();
        }
    }

    private final boolean isCanSelect() {
        return this.getSelectedCount() < this.maxSelectable;
    }

    private static final void initView$lambda-6$lambda-5(FilePickerActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.resetViewState();
        this$0.loadList();
    }

    public static final /* synthetic */ void access$initRv(FilePickerActivity $this, ArrayList listData, ArrayList navDataList) {
        $this.initRv(listData, navDataList);
    }

    public static final /* synthetic */ ArrayList access$getNavDataSource$p(FilePickerActivity $this) {
        return $this.navDataSource;
    }

    public static final /* synthetic */ void access$setLoadingFinish(FilePickerActivity $this) {
        $this.setLoadingFinish();
    }

    public static final /* synthetic */ FilePickerConfig access$getPickerConfig(FilePickerActivity $this) {
        return $this.getPickerConfig();
    }

    public static final /* synthetic */ void access$setNavDataSource$p(FilePickerActivity $this, ArrayList arrayList) {
        $this.navDataSource = arrayList;
    }

    public static final /* synthetic */ Handler access$getMainHandler$p(FilePickerActivity $this) {
        return $this.mainHandler;
    }

    public static final /* synthetic */ void access$updateItemUI(FilePickerActivity $this) {
        $this.updateItemUI();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/rosuh/filepicker/FilePickerActivity$Companion;", "", "()V", "FILE_PICKER_PERMISSION_REQUEST_CODE", "", "KEEP_ALIVE_TIME", "", "TAG", "", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

