/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowInsets;
import com.android.setupwizardlib.view.BottomScrollView;

public class StickyHeaderScrollView
extends BottomScrollView {
    private View mSticky;
    private View mStickyContainer;
    private int mStatusBarInset = 0;

    public StickyHeaderScrollView(Context context) {
        super(context);
    }

    public StickyHeaderScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StickyHeaderScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mSticky == null) {
            this.updateStickyView();
        }
        this.updateStickyHeaderPosition();
    }

    public void updateStickyView() {
        this.mSticky = this.findViewWithTag("sticky");
        this.mStickyContainer = this.findViewWithTag("stickyContainer");
    }

    private void updateStickyHeaderPosition() {
        if (Build.VERSION.SDK_INT >= 11 && this.mSticky != null) {
            View drawTarget = this.mStickyContainer != null ? this.mStickyContainer : this.mSticky;
            int drawOffset = this.mStickyContainer != null ? this.mSticky.getTop() : 0;
            int drawTop = drawTarget.getTop() - this.getScrollY();
            if (drawTop + drawOffset < this.mStatusBarInset || !drawTarget.isShown()) {
                drawTarget.setTranslationY((float)(this.getScrollY() - drawOffset));
            } else {
                drawTarget.setTranslationY(0.0f);
            }
        }
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.updateStickyHeaderPosition();
    }

    @TargetApi(value=21)
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        if (this.getFitsSystemWindows()) {
            this.mStatusBarInset = insets.getSystemWindowInsetTop();
            insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), 0, insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }
        return insets;
    }
}

