/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.android.setupwizardlib.R;

public class NavigationBar
extends LinearLayout
implements View.OnClickListener {
    private Button mNextButton;
    private Button mBackButton;
    private Button mMoreButton;
    private NavigationBarListener mListener;

    private static int getNavbarTheme(Context context) {
        TypedArray attributes = context.obtainStyledAttributes(new int[]{R.attr.suwNavBarTheme, 0x1010030, 0x1010031});
        int suwNavBarTheme = 0;
        int colorForeground = 1;
        int colorBackground = 2;
        int theme = attributes.getResourceId(suwNavBarTheme, 0);
        if (theme == 0) {
            float[] foregroundHsv = new float[3];
            float[] backgroundHsv = new float[3];
            Color.colorToHSV((int)attributes.getColor(colorForeground, 0), (float[])foregroundHsv);
            Color.colorToHSV((int)attributes.getColor(colorBackground, 0), (float[])backgroundHsv);
            boolean isDarkBg = foregroundHsv[2] > backgroundHsv[2];
            theme = isDarkBg ? R.style.SuwNavBarThemeDark : R.style.SuwNavBarThemeLight;
        }
        attributes.recycle();
        return theme;
    }

    private static Context getThemedContext(Context context) {
        int theme = NavigationBar.getNavbarTheme(context);
        return new ContextThemeWrapper(context, theme);
    }

    public NavigationBar(Context context) {
        super(NavigationBar.getThemedContext(context));
        this.init();
    }

    public NavigationBar(Context context, AttributeSet attrs) {
        super(NavigationBar.getThemedContext(context), attrs);
        this.init();
    }

    @TargetApi(value=11)
    public NavigationBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(NavigationBar.getThemedContext(context), attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        View.inflate((Context)this.getContext(), (int)R.layout.suw_navbar_view, (ViewGroup)this);
        this.mNextButton = (Button)this.findViewById(R.id.suw_navbar_next);
        this.mBackButton = (Button)this.findViewById(R.id.suw_navbar_back);
        this.mMoreButton = (Button)this.findViewById(R.id.suw_navbar_more);
    }

    public Button getBackButton() {
        return this.mBackButton;
    }

    public Button getNextButton() {
        return this.mNextButton;
    }

    public Button getMoreButton() {
        return this.mMoreButton;
    }

    public void setNavigationBarListener(NavigationBarListener listener) {
        this.mListener = listener;
        if (this.mListener != null) {
            this.getBackButton().setOnClickListener((View.OnClickListener)this);
            this.getNextButton().setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View view) {
        if (this.mListener != null) {
            if (view == this.getBackButton()) {
                this.mListener.onNavigateBack();
            } else if (view == this.getNextButton()) {
                this.mListener.onNavigateNext();
            }
        }
    }

    public static interface NavigationBarListener {
        public void onNavigateBack();

        public void onNavigateNext();
    }
}

