/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.setupwizardlib.R;

public class FillContentLayout
extends FrameLayout {
    private int mMaxWidth;
    private int mMaxHeight;

    public FillContentLayout(Context context) {
        this(context, null);
    }

    public FillContentLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.suwFillContentLayoutStyle);
    }

    public FillContentLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwFillContentLayout, defStyleAttr, 0);
        this.mMaxHeight = a.getDimensionPixelSize(R.styleable.SuwFillContentLayout_android_maxHeight, -1);
        this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SuwFillContentLayout_android_maxWidth, -1);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(FillContentLayout.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), FillContentLayout.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.measureIllustrationChild(this.getChildAt(i), this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    private void measureIllustrationChild(View child, int parentWidth, int parentHeight) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = FillContentLayout.getMaxSizeMeasureSpec(Math.min(this.mMaxWidth, parentWidth), this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin, lp.width);
        int childHeightMeasureSpec = FillContentLayout.getMaxSizeMeasureSpec(Math.min(this.mMaxHeight, parentHeight), this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private static int getMaxSizeMeasureSpec(int maxSize, int padding, int childDimension) {
        int size = Math.max(0, maxSize - padding);
        if (childDimension >= 0) {
            return View.MeasureSpec.makeMeasureSpec((int)childDimension, (int)0x40000000);
        }
        if (childDimension == -1) {
            return View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
        }
        if (childDimension == -2) {
            return View.MeasureSpec.makeMeasureSpec((int)size, (int)Integer.MIN_VALUE);
        }
        return 0;
    }
}

