/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.annotation.RequiresPermission;

public class SystemBarHelper {
    private static final String TAG = "SystemBarHelper";
    @SuppressLint(value={"InlinedApi"})
    private static final int DEFAULT_IMMERSIVE_FLAGS = 5634;
    @SuppressLint(value={"InlinedApi"})
    private static final int DIALOG_IMMERSIVE_FLAGS = 4098;
    private static final int STATUS_BAR_DISABLE_BACK = 0x400000;
    private static final int PEEK_DECOR_VIEW_RETRIES = 3;

    public static void hideSystemBars(Dialog dialog) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = dialog.getWindow();
            SystemBarHelper.temporarilyDisableDialogFocus(window);
            SystemBarHelper.addVisibilityFlag(window, 4098);
            SystemBarHelper.addImmersiveFlagsToDecorView(window, 4098);
            window.setNavigationBarColor(0);
            window.setStatusBarColor(0);
        }
    }

    public static void hideSystemBars(Window window) {
        if (Build.VERSION.SDK_INT >= 21) {
            SystemBarHelper.addVisibilityFlag(window, 5634);
            SystemBarHelper.addImmersiveFlagsToDecorView(window, 5634);
            window.setNavigationBarColor(0);
            window.setStatusBarColor(0);
        }
    }

    public static void showSystemBars(Dialog dialog, Context context) {
        SystemBarHelper.showSystemBars(dialog.getWindow(), context);
    }

    public static void showSystemBars(Window window, Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            SystemBarHelper.removeVisibilityFlag(window, 5634);
            SystemBarHelper.removeImmersiveFlagsFromDecorView(window, 5634);
            if (context != null) {
                TypedArray typedArray = context.obtainStyledAttributes(new int[]{16843857, 16843858});
                int statusBarColor = typedArray.getColor(0, 0);
                int navigationBarColor = typedArray.getColor(1, 0);
                window.setStatusBarColor(statusBarColor);
                window.setNavigationBarColor(navigationBarColor);
                typedArray.recycle();
            }
        }
    }

    public static void addVisibilityFlag(View view, int flag) {
        if (Build.VERSION.SDK_INT >= 11) {
            int vis = view.getSystemUiVisibility();
            view.setSystemUiVisibility(vis | flag);
        }
    }

    public static void addVisibilityFlag(Window window, int flag) {
        if (Build.VERSION.SDK_INT >= 11) {
            WindowManager.LayoutParams attrs = window.getAttributes();
            attrs.systemUiVisibility |= flag;
            window.setAttributes(attrs);
        }
    }

    public static void removeVisibilityFlag(View view, int flag) {
        if (Build.VERSION.SDK_INT >= 11) {
            int vis = view.getSystemUiVisibility();
            view.setSystemUiVisibility(vis & ~flag);
        }
    }

    public static void removeVisibilityFlag(Window window, int flag) {
        if (Build.VERSION.SDK_INT >= 11) {
            WindowManager.LayoutParams attrs = window.getAttributes();
            attrs.systemUiVisibility &= ~flag;
            window.setAttributes(attrs);
        }
    }

    @RequiresPermission(value="android.permission.STATUS_BAR")
    public static void setBackButtonVisible(Window window, boolean visible) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (visible) {
                SystemBarHelper.removeVisibilityFlag(window, 0x400000);
                SystemBarHelper.removeImmersiveFlagsFromDecorView(window, 0x400000);
            } else {
                SystemBarHelper.addVisibilityFlag(window, 0x400000);
                SystemBarHelper.addImmersiveFlagsToDecorView(window, 0x400000);
            }
        }
    }

    public static void setImeInsetView(View view) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)new WindowInsetsListener());
        }
    }

    @TargetApi(value=11)
    private static void addImmersiveFlagsToDecorView(Window window, final int vis) {
        SystemBarHelper.getDecorView(window, new OnDecorViewInstalledListener(){

            @Override
            public void onDecorViewInstalled(View decorView) {
                SystemBarHelper.addVisibilityFlag(decorView, vis);
            }
        });
    }

    @TargetApi(value=11)
    private static void removeImmersiveFlagsFromDecorView(Window window, final int vis) {
        SystemBarHelper.getDecorView(window, new OnDecorViewInstalledListener(){

            @Override
            public void onDecorViewInstalled(View decorView) {
                SystemBarHelper.removeVisibilityFlag(decorView, vis);
            }
        });
    }

    private static void getDecorView(Window window, OnDecorViewInstalledListener callback) {
        new DecorViewFinder().getDecorView(window, callback, 3);
    }

    private static void temporarilyDisableDialogFocus(final Window window) {
        window.setFlags(8, 8);
        window.setSoftInputMode(256);
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                window.clearFlags(8);
            }
        });
    }

    private static int getBottomDistance(View view) {
        int[] coords = new int[2];
        view.getLocationInWindow(coords);
        return view.getRootView().getHeight() - coords[1] - view.getHeight();
    }

    @TargetApi(value=21)
    private static class WindowInsetsListener
    implements View.OnApplyWindowInsetsListener {
        private int mBottomOffset;
        private boolean mHasCalculatedBottomOffset = false;

        private WindowInsetsListener() {
        }

        public WindowInsets onApplyWindowInsets(View view, WindowInsets insets) {
            if (!this.mHasCalculatedBottomOffset) {
                this.mBottomOffset = SystemBarHelper.getBottomDistance(view);
                this.mHasCalculatedBottomOffset = true;
            }
            int bottomInset = insets.getSystemWindowInsetBottom();
            int bottomMargin = Math.max(insets.getSystemWindowInsetBottom() - this.mBottomOffset, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            if (bottomMargin < lp.bottomMargin + view.getHeight()) {
                lp.setMargins(lp.leftMargin, lp.topMargin, lp.rightMargin, bottomMargin);
                view.setLayoutParams((ViewGroup.LayoutParams)lp);
                bottomInset = 0;
            }
            return insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), bottomInset);
        }
    }

    private static interface OnDecorViewInstalledListener {
        public void onDecorViewInstalled(View var1);
    }

    private static class DecorViewFinder {
        private final Handler mHandler = new Handler();
        private Window mWindow;
        private int mRetries;
        private OnDecorViewInstalledListener mCallback;
        private Runnable mCheckDecorViewRunnable = new Runnable(){

            @Override
            public void run() {
                View decorView = DecorViewFinder.this.mWindow.peekDecorView();
                if (decorView != null) {
                    DecorViewFinder.this.mCallback.onDecorViewInstalled(decorView);
                } else {
                    DecorViewFinder.this.mRetries--;
                    if (DecorViewFinder.this.mRetries >= 0) {
                        DecorViewFinder.this.mHandler.post(DecorViewFinder.this.mCheckDecorViewRunnable);
                    } else {
                        Log.w((String)SystemBarHelper.TAG, (String)("Cannot get decor view of window: " + DecorViewFinder.this.mWindow));
                    }
                }
            }
        };

        private DecorViewFinder() {
        }

        public void getDecorView(Window window, OnDecorViewInstalledListener callback, int retries) {
            this.mWindow = window;
            this.mRetries = retries;
            this.mCallback = callback;
            this.mCheckDecorViewRunnable.run();
        }
    }
}

