/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import androidx.annotation.AnyRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import java.util.List;

public class Partner {
    private static final String TAG = "(SUW) Partner";
    private static final String ACTION_PARTNER_CUSTOMIZATION = "com.android.setupwizard.action.PARTNER_CUSTOMIZATION";
    private static boolean sSearched = false;
    private static Partner sPartner;
    private final String mPackageName;
    private final Resources mResources;

    public static Drawable getDrawable(Context context, @DrawableRes int id2) {
        ResourceEntry entry = Partner.getResourceEntry(context, id2);
        return entry.resources.getDrawable(entry.id);
    }

    public static String getString(Context context, @StringRes int id2) {
        ResourceEntry entry = Partner.getResourceEntry(context, id2);
        return entry.resources.getString(entry.id);
    }

    public static int getColor(Context context, @ColorRes int id2) {
        ResourceEntry resourceEntry = Partner.getResourceEntry(context, id2);
        return resourceEntry.resources.getColor(resourceEntry.id);
    }

    public static CharSequence getText(Context context, @StringRes int id2) {
        ResourceEntry entry = Partner.getResourceEntry(context, id2);
        return entry.resources.getText(entry.id);
    }

    public static ResourceEntry getResourceEntry(Context context, @AnyRes int id2) {
        String type;
        Resources ourResources;
        String name;
        int partnerId;
        Partner partner = Partner.get(context);
        if (partner != null && (partnerId = partner.getIdentifier(name = (ourResources = context.getResources()).getResourceEntryName(id2), type = ourResources.getResourceTypeName(id2))) != 0) {
            return new ResourceEntry(partner.mResources, partnerId, true);
        }
        return new ResourceEntry(context.getResources(), id2, false);
    }

    public static synchronized Partner get(Context context) {
        if (!sSearched) {
            PackageManager pm = context.getPackageManager();
            Intent intent = new Intent(ACTION_PARTNER_CUSTOMIZATION);
            List receivers = Build.VERSION.SDK_INT >= 24 ? pm.queryBroadcastReceivers(intent, 0x1C0000) : pm.queryBroadcastReceivers(intent, 0);
            for (ResolveInfo info : receivers) {
                if (info.activityInfo == null) continue;
                ApplicationInfo appInfo = info.activityInfo.applicationInfo;
                if ((appInfo.flags & 1) == 0) continue;
                try {
                    Resources res = pm.getResourcesForApplication(appInfo);
                    sPartner = new Partner(appInfo.packageName, res);
                    break;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.w((String)TAG, (String)("Failed to find resources for " + appInfo.packageName));
                }
            }
            sSearched = true;
        }
        return sPartner;
    }

    @VisibleForTesting
    public static synchronized void resetForTesting() {
        sSearched = false;
        sPartner = null;
    }

    private Partner(String packageName, Resources res) {
        this.mPackageName = packageName;
        this.mResources = res;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public Resources getResources() {
        return this.mResources;
    }

    public int getIdentifier(String name, String defType) {
        return this.mResources.getIdentifier(name, defType, this.mPackageName);
    }

    public static class ResourceEntry {
        public Resources resources;
        public int id;
        public boolean isOverlay;

        ResourceEntry(Resources resources, int id2, boolean isOverlay) {
            this.resources = resources;
            this.id = id2;
            this.isOverlay = isOverlay;
        }
    }
}

