/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.Mixin;
import com.android.setupwizardlib.view.NavigationBar;

public class RequireScrollMixin
implements Mixin {
    @NonNull
    private final TemplateLayout mTemplateLayout;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean mRequiringScrollToBottom = false;
    private boolean mEverScrolledToBottom = false;
    private ScrollHandlingDelegate mDelegate;
    @Nullable
    private OnRequireScrollStateChangedListener mListener;

    public RequireScrollMixin(@NonNull TemplateLayout templateLayout) {
        this.mTemplateLayout = templateLayout;
    }

    public void setScrollHandlingDelegate(@NonNull ScrollHandlingDelegate delegate) {
        this.mDelegate = delegate;
    }

    public void setOnRequireScrollStateChangedListener(@Nullable OnRequireScrollStateChangedListener listener) {
        this.mListener = listener;
    }

    public OnRequireScrollStateChangedListener getOnRequireScrollStateChangedListener() {
        return this.mListener;
    }

    public View.OnClickListener createOnClickListener(final @Nullable View.OnClickListener listener) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (RequireScrollMixin.this.mRequiringScrollToBottom) {
                    RequireScrollMixin.this.mDelegate.pageScrollDown();
                } else if (listener != null) {
                    listener.onClick(view);
                }
            }
        };
    }

    public void requireScrollWithNavigationBar(final @NonNull NavigationBar navigationBar) {
        this.setOnRequireScrollStateChangedListener(new OnRequireScrollStateChangedListener(){

            @Override
            public void onRequireScrollStateChanged(boolean scrollNeeded) {
                navigationBar.getMoreButton().setVisibility(scrollNeeded ? 0 : 8);
                navigationBar.getNextButton().setVisibility(scrollNeeded ? 8 : 0);
            }
        });
        navigationBar.getMoreButton().setOnClickListener(this.createOnClickListener(null));
        this.requireScroll();
    }

    public void requireScrollWithButton(@NonNull Button button, @StringRes int moreText, @Nullable View.OnClickListener onClickListener) {
        this.requireScrollWithButton(button, button.getContext().getText(moreText), onClickListener);
    }

    public void requireScrollWithButton(final @NonNull Button button, final CharSequence moreText, @Nullable View.OnClickListener onClickListener) {
        final CharSequence nextText = button.getText();
        button.setOnClickListener(this.createOnClickListener(onClickListener));
        this.setOnRequireScrollStateChangedListener(new OnRequireScrollStateChangedListener(){

            @Override
            public void onRequireScrollStateChanged(boolean scrollNeeded) {
                button.setText(scrollNeeded ? moreText : nextText);
            }
        });
        this.requireScroll();
    }

    public boolean isScrollingRequired() {
        return this.mRequiringScrollToBottom;
    }

    public void requireScroll() {
        this.mDelegate.startListening();
    }

    void notifyScrollabilityChange(boolean canScrollDown) {
        if (canScrollDown == this.mRequiringScrollToBottom) {
            return;
        }
        if (canScrollDown) {
            if (!this.mEverScrolledToBottom) {
                this.postScrollStateChange(true);
                this.mRequiringScrollToBottom = true;
            }
        } else {
            this.postScrollStateChange(false);
            this.mRequiringScrollToBottom = false;
            this.mEverScrolledToBottom = true;
        }
    }

    private void postScrollStateChange(final boolean scrollNeeded) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RequireScrollMixin.this.mListener != null) {
                    RequireScrollMixin.this.mListener.onRequireScrollStateChanged(scrollNeeded);
                }
            }
        });
    }

    static interface ScrollHandlingDelegate {
        public void startListening();

        public void pageScrollDown();
    }

    public static interface OnRequireScrollStateChangedListener {
        public void onRequireScrollStateChanged(boolean var1);
    }
}

