/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.span;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;

public class LinkSpan
extends ClickableSpan {
    private static final String TAG = "LinkSpan";
    private static final Typeface TYPEFACE_MEDIUM = Typeface.create((String)"sans-serif-medium", (int)0);
    private final String mId;

    public LinkSpan(String id2) {
        this.mId = id2;
    }

    public void onClick(View view) {
        CharSequence text;
        if (this.dispatchClick(view)) {
            if (Build.VERSION.SDK_INT >= 19) {
                view.cancelPendingInputEvents();
            }
        } else {
            Log.w((String)TAG, (String)"Dropping click event. No listener attached.");
        }
        if (view instanceof TextView && (text = ((TextView)view).getText()) instanceof Spannable) {
            Selection.setSelection((Spannable)((Spannable)text), (int)0);
        }
    }

    private boolean dispatchClick(View view) {
        OnClickListener listener;
        boolean handled = false;
        if (view instanceof OnLinkClickListener) {
            handled = ((OnLinkClickListener)view).onLinkClick(this);
        }
        if (!handled && (listener = this.getLegacyListenerFromContext(view.getContext())) != null) {
            listener.onClick(this);
            handled = true;
        }
        return handled;
    }

    @Deprecated
    @Nullable
    private OnClickListener getLegacyListenerFromContext(@Nullable Context context) {
        while (true) {
            if (context instanceof OnClickListener) {
                return (OnClickListener)context;
            }
            if (!(context instanceof ContextWrapper)) break;
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public void updateDrawState(TextPaint drawState) {
        super.updateDrawState(drawState);
        drawState.setUnderlineText(false);
        drawState.setTypeface(TYPEFACE_MEDIUM);
    }

    public String getId() {
        return this.mId;
    }

    public static interface OnLinkClickListener {
        public boolean onLinkClick(LinkSpan var1);
    }

    @Deprecated
    public static interface OnClickListener {
        public void onClick(LinkSpan var1);
    }
}

