/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.Mixin;

public class IconMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;

    public IconMixin(TemplateLayout layout2, AttributeSet attrs, int defStyleAttr) {
        this.mTemplateLayout = layout2;
        Context context = layout2.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwIconMixin, defStyleAttr, 0);
        int icon = a.getResourceId(R.styleable.SuwIconMixin_android_icon, 0);
        if (icon != 0) {
            this.setIcon(icon);
        }
        a.recycle();
    }

    public void setIcon(Drawable icon) {
        ImageView iconView = this.getView();
        if (iconView != null) {
            iconView.setImageDrawable(icon);
            iconView.setVisibility(icon != null ? 0 : 8);
        }
    }

    public void setIcon(@DrawableRes int icon) {
        ImageView iconView = this.getView();
        if (iconView != null) {
            iconView.setImageResource(icon);
            iconView.setVisibility(icon != 0 ? 0 : 8);
        }
    }

    public Drawable getIcon() {
        ImageView iconView = this.getView();
        return iconView != null ? iconView.getDrawable() : null;
    }

    public void setContentDescription(CharSequence description) {
        ImageView iconView = this.getView();
        if (iconView != null) {
            iconView.setContentDescription(description);
        }
    }

    public CharSequence getContentDescription() {
        ImageView iconView = this.getView();
        return iconView != null ? iconView.getContentDescription() : null;
    }

    protected ImageView getView() {
        return (ImageView)this.mTemplateLayout.findManagedViewById(R.id.suw_layout_icon);
    }
}

