/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.setupwizardlib.items.AbstractItemHierarchy;
import com.android.setupwizardlib.items.IItem;
import com.android.setupwizardlib.items.ItemHierarchy;
import com.android.setupwizardlib.items.ItemInflater;
import java.util.ArrayList;
import java.util.List;

public class ItemGroup
extends AbstractItemHierarchy
implements ItemInflater.ItemParent,
ItemHierarchy.Observer {
    private static final String TAG = "ItemGroup";
    private List<ItemHierarchy> mChildren = new ArrayList<ItemHierarchy>();
    private SparseIntArray mHierarchyStart = new SparseIntArray();
    private int mCount = 0;
    private boolean mDirty = false;

    private static int binarySearch(SparseIntArray array, int value) {
        int size = array.size();
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array.valueAt(mid);
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return array.keyAt(mid);
        }
        return array.keyAt(lo - 1);
    }

    private static <T> int identityIndexOf(List<T> list, T object) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            if (list.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public ItemGroup() {
    }

    public ItemGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void addChild(ItemHierarchy child) {
        this.mDirty = true;
        this.mChildren.add(child);
        child.registerObserver(this);
        int count = child.getCount();
        if (count > 0) {
            this.notifyItemRangeInserted(this.getChildPosition(child), count);
        }
    }

    public boolean removeChild(ItemHierarchy child) {
        int childIndex = ItemGroup.identityIndexOf(this.mChildren, child);
        int childPosition = this.getChildPosition(childIndex);
        this.mDirty = true;
        if (childIndex != -1) {
            int childCount = child.getCount();
            this.mChildren.remove(childIndex);
            child.unregisterObserver(this);
            if (childCount > 0) {
                this.notifyItemRangeRemoved(childPosition, childCount);
            }
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.mChildren.size() == 0) {
            return;
        }
        int numRemoved = this.getCount();
        for (ItemHierarchy item : this.mChildren) {
            item.unregisterObserver(this);
        }
        this.mDirty = true;
        this.mChildren.clear();
        this.notifyItemRangeRemoved(0, numRemoved);
    }

    @Override
    public int getCount() {
        this.updateDataIfNeeded();
        return this.mCount;
    }

    @Override
    public IItem getItemAt(int position) {
        int itemIndex = this.getItemIndex(position);
        ItemHierarchy item = this.mChildren.get(itemIndex);
        int subpos = position - this.mHierarchyStart.get(itemIndex);
        return item.getItemAt(subpos);
    }

    @Override
    public void onChanged(ItemHierarchy hierarchy) {
        this.mDirty = true;
        this.notifyChanged();
    }

    private int getChildPosition(ItemHierarchy child) {
        return this.getChildPosition(ItemGroup.identityIndexOf(this.mChildren, child));
    }

    private int getChildPosition(int childIndex) {
        this.updateDataIfNeeded();
        if (childIndex != -1) {
            int childPos = -1;
            int childCount = this.mChildren.size();
            for (int i = childIndex; childPos < 0 && i < childCount; ++i) {
                childPos = this.mHierarchyStart.get(i, -1);
            }
            if (childPos < 0) {
                childPos = this.getCount();
            }
            return childPos;
        }
        return -1;
    }

    @Override
    public void onItemRangeChanged(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        int childPosition = this.getChildPosition(itemHierarchy);
        if (childPosition >= 0) {
            this.notifyItemRangeChanged(childPosition + positionStart, itemCount);
        } else {
            Log.e((String)TAG, (String)("Unexpected child change " + itemHierarchy));
        }
    }

    @Override
    public void onItemRangeInserted(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.mDirty = true;
        int childPosition = this.getChildPosition(itemHierarchy);
        if (childPosition >= 0) {
            this.notifyItemRangeInserted(childPosition + positionStart, itemCount);
        } else {
            Log.e((String)TAG, (String)("Unexpected child insert " + itemHierarchy));
        }
    }

    @Override
    public void onItemRangeMoved(ItemHierarchy itemHierarchy, int fromPosition, int toPosition, int itemCount) {
        this.mDirty = true;
        int childPosition = this.getChildPosition(itemHierarchy);
        if (childPosition >= 0) {
            this.notifyItemRangeMoved(childPosition + fromPosition, childPosition + toPosition, itemCount);
        } else {
            Log.e((String)TAG, (String)("Unexpected child move " + itemHierarchy));
        }
    }

    @Override
    public void onItemRangeRemoved(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.mDirty = true;
        int childPosition = this.getChildPosition(itemHierarchy);
        if (childPosition >= 0) {
            this.notifyItemRangeRemoved(childPosition + positionStart, itemCount);
        } else {
            Log.e((String)TAG, (String)("Unexpected child remove " + itemHierarchy));
        }
    }

    @Override
    public ItemHierarchy findItemById(int id2) {
        if (id2 == this.getId()) {
            return this;
        }
        for (ItemHierarchy child : this.mChildren) {
            ItemHierarchy childFindItem = child.findItemById(id2);
            if (childFindItem == null) continue;
            return childFindItem;
        }
        return null;
    }

    private void updateDataIfNeeded() {
        if (this.mDirty) {
            this.mCount = 0;
            this.mHierarchyStart.clear();
            for (int itemIndex = 0; itemIndex < this.mChildren.size(); ++itemIndex) {
                ItemHierarchy item = this.mChildren.get(itemIndex);
                if (item.getCount() > 0) {
                    this.mHierarchyStart.put(itemIndex, this.mCount);
                }
                this.mCount += item.getCount();
            }
            this.mDirty = false;
        }
    }

    private int getItemIndex(int position) {
        this.updateDataIfNeeded();
        if (position < 0 || position >= this.mCount) {
            throw new IndexOutOfBoundsException("size=" + this.mCount + "; index=" + position);
        }
        int result = ItemGroup.binarySearch(this.mHierarchyStart, position);
        if (result < 0) {
            throw new IllegalStateException("Cannot have item start index < 0");
        }
        return result;
    }
}

