/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.AbstractItem;

public class ButtonItem
extends AbstractItem
implements View.OnClickListener {
    private boolean mEnabled = true;
    private CharSequence mText;
    private int mTheme = R.style.SuwButtonItem;
    private OnClickListener mListener;
    private Button mButton;

    public ButtonItem() {
    }

    public ButtonItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwButtonItem);
        this.mEnabled = a.getBoolean(R.styleable.SuwButtonItem_android_enabled, true);
        this.mText = a.getText(R.styleable.SuwButtonItem_android_text);
        this.mTheme = a.getResourceId(R.styleable.SuwButtonItem_android_theme, R.style.SuwButtonItem);
        a.recycle();
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mListener = listener;
    }

    public void setText(CharSequence text) {
        this.mText = text;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setTheme(int theme) {
        this.mTheme = theme;
        this.mButton = null;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public int getLayoutResource() {
        return 0;
    }

    @Override
    public final void onBindView(View view) {
        throw new UnsupportedOperationException("Cannot bind to ButtonItem's view");
    }

    protected Button createButton(ViewGroup parent) {
        if (this.mButton == null) {
            Context context = parent.getContext();
            if (this.mTheme != 0) {
                context = new ContextThemeWrapper(context, this.mTheme);
            }
            this.mButton = this.createButton(context);
            this.mButton.setOnClickListener((View.OnClickListener)this);
        } else if (this.mButton.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mButton.getParent()).removeView((View)this.mButton);
        }
        this.mButton.setEnabled(this.mEnabled);
        this.mButton.setText(this.mText);
        this.mButton.setId(this.getViewId());
        return this.mButton;
    }

    public void onClick(View v) {
        if (this.mListener != null) {
            this.mListener.onClick(this);
        }
    }

    @SuppressLint(value={"InflateParams"})
    private Button createButton(Context context) {
        return (Button)LayoutInflater.from((Context)context).inflate(R.layout.suw_button, null, false);
    }

    public static interface OnClickListener {
        public void onClick(ButtonItem var1);
    }
}

