/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.AbstractItem;
import com.android.setupwizardlib.items.ButtonItem;
import com.android.setupwizardlib.items.ItemHierarchy;
import com.android.setupwizardlib.items.ItemInflater;
import java.util.ArrayList;

public class ButtonBarItem
extends AbstractItem
implements ItemInflater.ItemParent {
    private final ArrayList<ButtonItem> mButtons = new ArrayList();
    private boolean mVisible = true;

    public ButtonBarItem() {
    }

    public ButtonBarItem(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public int getCount() {
        return this.isVisible() ? 1 : 0;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public int getLayoutResource() {
        return R.layout.suw_items_button_bar;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    @Override
    public int getViewId() {
        return this.getId();
    }

    @Override
    public void onBindView(View view) {
        LinearLayout layout2 = (LinearLayout)view;
        layout2.removeAllViews();
        for (ButtonItem buttonItem : this.mButtons) {
            Button button = buttonItem.createButton((ViewGroup)layout2);
            layout2.addView((View)button);
        }
        view.setId(this.getViewId());
    }

    @Override
    public void addChild(ItemHierarchy child) {
        if (!(child instanceof ButtonItem)) {
            throw new UnsupportedOperationException("Cannot add non-button item to Button Bar");
        }
        this.mButtons.add((ButtonItem)child);
    }

    @Override
    public ItemHierarchy findItemById(int id2) {
        if (this.getId() == id2) {
            return this;
        }
        for (ButtonItem button : this.mButtons) {
            ItemHierarchy item = button.findItemById(id2);
            if (item == null) continue;
            return item;
        }
        return null;
    }
}

