/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.gesture;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;

public final class ConsecutiveTapsGestureDetector {
    private final View mView;
    private final OnConsecutiveTapsListener mListener;
    private final int mConsecutiveTapTouchSlopSquare;
    private final int mConsecutiveTapTimeout;
    private int mConsecutiveTapsCounter = 0;
    private MotionEvent mPreviousTapEvent;

    public ConsecutiveTapsGestureDetector(OnConsecutiveTapsListener listener, View view) {
        this.mListener = listener;
        this.mView = view;
        int doubleTapSlop = ViewConfiguration.get((Context)this.mView.getContext()).getScaledDoubleTapSlop();
        this.mConsecutiveTapTouchSlopSquare = doubleTapSlop * doubleTapSlop;
        this.mConsecutiveTapTimeout = ViewConfiguration.getDoubleTapTimeout();
    }

    public void onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1) {
            Rect viewRect = new Rect();
            int[] leftTop = new int[2];
            this.mView.getLocationOnScreen(leftTop);
            viewRect.set(leftTop[0], leftTop[1], leftTop[0] + this.mView.getWidth(), leftTop[1] + this.mView.getHeight());
            if (viewRect.contains((int)ev.getX(), (int)ev.getY())) {
                this.mConsecutiveTapsCounter = this.isConsecutiveTap(ev) ? ++this.mConsecutiveTapsCounter : 1;
                this.mListener.onConsecutiveTaps(this.mConsecutiveTapsCounter);
            } else {
                this.mConsecutiveTapsCounter = 0;
            }
            if (this.mPreviousTapEvent != null) {
                this.mPreviousTapEvent.recycle();
            }
            this.mPreviousTapEvent = MotionEvent.obtain((MotionEvent)ev);
        }
    }

    public void resetCounter() {
        this.mConsecutiveTapsCounter = 0;
    }

    private boolean isConsecutiveTap(MotionEvent currentTapEvent) {
        if (this.mPreviousTapEvent == null) {
            return false;
        }
        double deltaX = this.mPreviousTapEvent.getX() - currentTapEvent.getX();
        double deltaY = this.mPreviousTapEvent.getY() - currentTapEvent.getY();
        long deltaTime = currentTapEvent.getEventTime() - this.mPreviousTapEvent.getEventTime();
        return deltaX * deltaX + deltaY * deltaY <= (double)this.mConsecutiveTapTouchSlopSquare && deltaTime < (long)this.mConsecutiveTapTimeout;
    }

    public static interface OnConsecutiveTapsListener {
        public void onConsecutiveTaps(int var1);
    }
}

