/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Keep;
import android.support.annotation.LayoutRes;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.template.Mixin;
import com.android.setupwizardlib.util.FallbackThemeWrapper;
import java.util.HashMap;
import java.util.Map;

public class TemplateLayout
extends FrameLayout {
    private ViewGroup mContainer;
    private Map<Class<? extends Mixin>, Mixin> mMixins = new HashMap<Class<? extends Mixin>, Mixin>();
    private float mXFraction;
    private ViewTreeObserver.OnPreDrawListener mPreDrawListener;

    public TemplateLayout(Context context, int template, int containerId) {
        super(context);
        this.init(template, containerId, null, R.attr.suwLayoutTheme);
    }

    public TemplateLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(0, 0, attrs, R.attr.suwLayoutTheme);
    }

    @TargetApi(value=11)
    public TemplateLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(0, 0, attrs, defStyleAttr);
    }

    private void init(int template, int containerId, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuwTemplateLayout, defStyleAttr, 0);
        if (template == 0) {
            template = a.getResourceId(R.styleable.SuwTemplateLayout_android_layout, 0);
        }
        if (containerId == 0) {
            containerId = a.getResourceId(R.styleable.SuwTemplateLayout_suwContainer, 0);
        }
        this.inflateTemplate(template, containerId);
        a.recycle();
    }

    protected <M extends Mixin> void registerMixin(Class<M> cls, M mixin) {
        this.mMixins.put(cls, mixin);
    }

    public <T extends View> T findManagedViewById(int id2) {
        return (T)this.findViewById(id2);
    }

    public <M extends Mixin> M getMixin(Class<M> cls) {
        return (M)this.mMixins.get(cls);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.mContainer.addView(child, index, params);
    }

    private void addViewInternal(View child) {
        super.addView(child, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
    }

    private void inflateTemplate(int templateResource, int containerId) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View templateRoot = this.onInflateTemplate(inflater, templateResource);
        this.addViewInternal(templateRoot);
        this.mContainer = this.findContainer(containerId);
        if (this.mContainer == null) {
            throw new IllegalArgumentException("Container cannot be null in TemplateLayout");
        }
        this.onTemplateInflated();
    }

    protected View onInflateTemplate(LayoutInflater inflater, @LayoutRes int template) {
        return this.inflateTemplate(inflater, 0, template);
    }

    protected final View inflateTemplate(LayoutInflater inflater, @StyleRes int fallbackTheme, @LayoutRes int template) {
        if (template == 0) {
            throw new IllegalArgumentException("android:layout not specified for TemplateLayout");
        }
        if (fallbackTheme != 0) {
            inflater = LayoutInflater.from((Context)new FallbackThemeWrapper(inflater.getContext(), fallbackTheme));
        }
        return inflater.inflate(template, (ViewGroup)this, false);
    }

    protected ViewGroup findContainer(int containerId) {
        if (containerId == 0) {
            containerId = this.getContainerId();
        }
        return (ViewGroup)this.findViewById(containerId);
    }

    protected void onTemplateInflated() {
    }

    @Deprecated
    protected int getContainerId() {
        return 0;
    }

    @Keep
    @TargetApi(value=11)
    public void setXFraction(float fraction) {
        this.mXFraction = fraction;
        int width = this.getWidth();
        if (width != 0) {
            this.setTranslationX((float)width * fraction);
        } else if (this.mPreDrawListener == null) {
            this.mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    TemplateLayout.this.getViewTreeObserver().removeOnPreDrawListener(TemplateLayout.this.mPreDrawListener);
                    TemplateLayout.this.setXFraction(TemplateLayout.this.mXFraction);
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
        }
    }

    @Keep
    @TargetApi(value=11)
    public float getXFraction() {
        return this.mXFraction;
    }
}

