/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import android.widget.TextView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.HeaderMixin;
import com.android.setupwizardlib.template.NavigationBarMixin;
import com.android.setupwizardlib.template.ProgressBarMixin;
import com.android.setupwizardlib.template.RequireScrollMixin;
import com.android.setupwizardlib.template.ScrollViewScrollHandlingDelegate;
import com.android.setupwizardlib.view.Illustration;
import com.android.setupwizardlib.view.NavigationBar;

public class SetupWizardLayout
extends TemplateLayout {
    private static final String TAG = "SetupWizardLayout";

    public SetupWizardLayout(Context context) {
        super(context, 0, 0);
        this.init(null, R.attr.suwLayoutTheme);
    }

    public SetupWizardLayout(Context context, int template) {
        this(context, template, 0);
    }

    public SetupWizardLayout(Context context, int template, int containerId) {
        super(context, template, containerId);
        this.init(null, R.attr.suwLayoutTheme);
    }

    public SetupWizardLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, R.attr.suwLayoutTheme);
    }

    @TargetApi(value=11)
    public SetupWizardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a;
        Drawable background;
        this.registerMixin(HeaderMixin.class, new HeaderMixin(this, attrs, defStyleAttr));
        this.registerMixin(ProgressBarMixin.class, new ProgressBarMixin(this));
        this.registerMixin(NavigationBarMixin.class, new NavigationBarMixin(this));
        RequireScrollMixin requireScrollMixin = new RequireScrollMixin(this);
        this.registerMixin(RequireScrollMixin.class, requireScrollMixin);
        ScrollView scrollView = this.getScrollView();
        if (scrollView != null) {
            requireScrollMixin.setScrollHandlingDelegate(new ScrollViewScrollHandlingDelegate(requireScrollMixin, scrollView));
        }
        if ((background = (a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuwSetupWizardLayout, defStyleAttr, 0)).getDrawable(R.styleable.SuwSetupWizardLayout_suwBackground)) != null) {
            this.setLayoutBackground(background);
        } else {
            Drawable backgroundTile = a.getDrawable(R.styleable.SuwSetupWizardLayout_suwBackgroundTile);
            if (backgroundTile != null) {
                this.setBackgroundTile(backgroundTile);
            }
        }
        Drawable illustration = a.getDrawable(R.styleable.SuwSetupWizardLayout_suwIllustration);
        if (illustration != null) {
            this.setIllustration(illustration);
        } else {
            Drawable illustrationImage = a.getDrawable(R.styleable.SuwSetupWizardLayout_suwIllustrationImage);
            Drawable horizontalTile = a.getDrawable(R.styleable.SuwSetupWizardLayout_suwIllustrationHorizontalTile);
            if (illustrationImage != null && horizontalTile != null) {
                this.setIllustration(illustrationImage, horizontalTile);
            }
        }
        int decorPaddingTop = a.getDimensionPixelSize(R.styleable.SuwSetupWizardLayout_suwDecorPaddingTop, -1);
        if (decorPaddingTop == -1) {
            decorPaddingTop = this.getResources().getDimensionPixelSize(R.dimen.suw_decor_padding_top);
        }
        this.setDecorPaddingTop(decorPaddingTop);
        float illustrationAspectRatio = a.getFloat(R.styleable.SuwSetupWizardLayout_suwIllustrationAspectRatio, -1.0f);
        if (illustrationAspectRatio == -1.0f) {
            TypedValue out = new TypedValue();
            this.getResources().getValue(R.dimen.suw_illustration_aspect_ratio, out, true);
            illustrationAspectRatio = out.getFloat();
        }
        this.setIllustrationAspectRatio(illustrationAspectRatio);
        a.recycle();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState ss = new SavedState(parcelable);
        ss.mIsProgressBarShown = this.isProgressBarShown();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            Log.w((String)TAG, (String)("Ignoring restore instance state " + state));
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        boolean isProgressBarShown = ss.mIsProgressBarShown;
        this.setProgressBarShown(isProgressBarShown);
    }

    @Override
    protected View onInflateTemplate(LayoutInflater inflater, int template) {
        if (template == 0) {
            template = R.layout.suw_template;
        }
        return this.inflateTemplate(inflater, R.style.SuwThemeMaterial_Light, template);
    }

    @Override
    protected ViewGroup findContainer(int containerId) {
        if (containerId == 0) {
            containerId = R.id.suw_layout_content;
        }
        return super.findContainer(containerId);
    }

    public NavigationBar getNavigationBar() {
        return this.getMixin(NavigationBarMixin.class).getNavigationBar();
    }

    public ScrollView getScrollView() {
        Object view = this.findManagedViewById(R.id.suw_bottom_scroll_view);
        return view instanceof ScrollView ? (ScrollView)view : null;
    }

    public void requireScrollToBottom() {
        RequireScrollMixin requireScrollMixin = this.getMixin(RequireScrollMixin.class);
        NavigationBar navigationBar = this.getNavigationBar();
        if (navigationBar != null) {
            requireScrollMixin.requireScrollWithNavigationBar(navigationBar);
        } else {
            Log.e((String)TAG, (String)"Cannot require scroll. Navigation bar is null.");
        }
    }

    public void setHeaderText(int title) {
        this.getMixin(HeaderMixin.class).setText(title);
    }

    public void setHeaderText(CharSequence title) {
        this.getMixin(HeaderMixin.class).setText(title);
    }

    public CharSequence getHeaderText() {
        return this.getMixin(HeaderMixin.class).getText();
    }

    public TextView getHeaderTextView() {
        return this.getMixin(HeaderMixin.class).getTextView();
    }

    public void setIllustration(Drawable drawable) {
        Object view = this.findManagedViewById(R.id.suw_layout_decor);
        if (view instanceof Illustration) {
            Illustration illustration = (Illustration)((Object)view);
            illustration.setIllustration(drawable);
        }
    }

    public void setIllustration(int asset, int horizontalTile) {
        Object view = this.findManagedViewById(R.id.suw_layout_decor);
        if (view instanceof Illustration) {
            Illustration illustration = (Illustration)((Object)view);
            Drawable illustrationDrawable = this.getIllustration(asset, horizontalTile);
            illustration.setIllustration(illustrationDrawable);
        }
    }

    private void setIllustration(Drawable asset, Drawable horizontalTile) {
        Object view = this.findManagedViewById(R.id.suw_layout_decor);
        if (view instanceof Illustration) {
            Illustration illustration = (Illustration)((Object)view);
            Drawable illustrationDrawable = this.getIllustration(asset, horizontalTile);
            illustration.setIllustration(illustrationDrawable);
        }
    }

    public void setIllustrationAspectRatio(float aspectRatio) {
        Object view = this.findManagedViewById(R.id.suw_layout_decor);
        if (view instanceof Illustration) {
            Illustration illustration = (Illustration)((Object)view);
            illustration.setAspectRatio(aspectRatio);
        }
    }

    public void setDecorPaddingTop(int paddingTop) {
        Object view = this.findManagedViewById(R.id.suw_layout_decor);
        if (view != null) {
            view.setPadding(view.getPaddingLeft(), paddingTop, view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public void setLayoutBackground(Drawable background) {
        Object view = this.findManagedViewById(R.id.suw_layout_decor);
        if (view != null) {
            view.setBackgroundDrawable(background);
        }
    }

    public void setBackgroundTile(int backgroundTile) {
        Drawable backgroundTileDrawable = this.getContext().getResources().getDrawable(backgroundTile);
        this.setBackgroundTile(backgroundTileDrawable);
    }

    private void setBackgroundTile(Drawable backgroundTile) {
        if (backgroundTile instanceof BitmapDrawable) {
            ((BitmapDrawable)backgroundTile).setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        }
        this.setLayoutBackground(backgroundTile);
    }

    private Drawable getIllustration(int asset, int horizontalTile) {
        Context context = this.getContext();
        Drawable assetDrawable = context.getResources().getDrawable(asset);
        Drawable tile = context.getResources().getDrawable(horizontalTile);
        return this.getIllustration(assetDrawable, tile);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private Drawable getIllustration(Drawable asset, Drawable horizontalTile) {
        Context context = this.getContext();
        if (context.getResources().getBoolean(R.bool.suwUseTabletLayout)) {
            if (horizontalTile instanceof BitmapDrawable) {
                ((BitmapDrawable)horizontalTile).setTileModeX(Shader.TileMode.REPEAT);
                ((BitmapDrawable)horizontalTile).setGravity(48);
            }
            if (asset instanceof BitmapDrawable) {
                ((BitmapDrawable)asset).setGravity(51);
            }
            LayerDrawable layers = new LayerDrawable(new Drawable[]{horizontalTile, asset});
            if (Build.VERSION.SDK_INT >= 19) {
                layers.setAutoMirrored(true);
            }
            return layers;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            asset.setAutoMirrored(true);
        }
        return asset;
    }

    public boolean isProgressBarShown() {
        return this.getMixin(ProgressBarMixin.class).isShown();
    }

    public void setProgressBarShown(boolean shown) {
        this.getMixin(ProgressBarMixin.class).setShown(shown);
    }

    @Deprecated
    public void showProgressBar() {
        this.setProgressBarShown(true);
    }

    @Deprecated
    public void hideProgressBar() {
        this.setProgressBarShown(false);
    }

    public void setProgressBarColor(ColorStateList color) {
        this.getMixin(ProgressBarMixin.class).setColor(color);
    }

    public ColorStateList getProgressBarColor() {
        return this.getMixin(ProgressBarMixin.class).getColor();
    }

    protected static class SavedState
    extends View.BaseSavedState {
        boolean mIsProgressBarShown = false;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public SavedState(Parcel source) {
            super(source);
            this.mIsProgressBarShown = source.readInt() != 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mIsProgressBarShown ? 1 : 0);
        }
    }
}

