/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.android.setupwizardlib.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    public static final int DIVIDER_CONDITION_EITHER = 0;
    public static final int DIVIDER_CONDITION_BOTH = 1;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerIntrinsicHeight;
    private int mDividerCondition;

    @Deprecated
    public static DividerItemDecoration getDefault(Context context) {
        return new DividerItemDecoration(context);
    }

    public DividerItemDecoration() {
    }

    public DividerItemDecoration(Context context) {
        TypedArray a = context.obtainStyledAttributes(R.styleable.SuwDividerItemDecoration);
        Drawable divider = a.getDrawable(R.styleable.SuwDividerItemDecoration_android_listDivider);
        int dividerHeight = a.getDimensionPixelSize(R.styleable.SuwDividerItemDecoration_android_dividerHeight, 0);
        int dividerCondition = a.getInt(R.styleable.SuwDividerItemDecoration_suwDividerCondition, 0);
        a.recycle();
        this.setDivider(divider);
        this.setDividerHeight(dividerHeight);
        this.setDividerCondition(dividerCondition);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider == null) {
            return;
        }
        int childCount = parent.getChildCount();
        int width = parent.getWidth();
        int dividerHeight = this.mDividerHeight != 0 ? this.mDividerHeight : this.mDividerIntrinsicHeight;
        for (int childViewIndex = 0; childViewIndex < childCount; ++childViewIndex) {
            View view = parent.getChildAt(childViewIndex);
            if (!this.shouldDrawDividerBelow(view, parent)) continue;
            int top = (int)ViewCompat.getY((View)view) + view.getHeight();
            this.mDivider.setBounds(0, top, width, top + dividerHeight);
            this.mDivider.draw(c);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.shouldDrawDividerBelow(view, parent)) {
            outRect.bottom = this.mDividerHeight != 0 ? this.mDividerHeight : this.mDividerIntrinsicHeight;
        }
    }

    private boolean shouldDrawDividerBelow(View view, RecyclerView parent) {
        RecyclerView.ViewHolder nextHolder;
        RecyclerView.ViewHolder holder = parent.getChildViewHolder(view);
        int index = holder.getLayoutPosition();
        int lastItemIndex = parent.getAdapter().getItemCount() - 1;
        if (this.isDividerAllowedBelow(holder)) {
            if (this.mDividerCondition == 0) {
                return true;
            }
        } else if (this.mDividerCondition == 1 || index == lastItemIndex) {
            return false;
        }
        return index >= lastItemIndex || this.isDividerAllowedAbove(nextHolder = parent.findViewHolderForLayoutPosition(index + 1));
    }

    protected boolean isDividerAllowedAbove(RecyclerView.ViewHolder viewHolder) {
        return !(viewHolder instanceof DividedViewHolder) || ((DividedViewHolder)viewHolder).isDividerAllowedAbove();
    }

    protected boolean isDividerAllowedBelow(RecyclerView.ViewHolder viewHolder) {
        return !(viewHolder instanceof DividedViewHolder) || ((DividedViewHolder)viewHolder).isDividerAllowedBelow();
    }

    public void setDivider(Drawable divider) {
        this.mDividerIntrinsicHeight = divider != null ? divider.getIntrinsicHeight() : 0;
        this.mDivider = divider;
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDividerHeight(int dividerHeight) {
        this.mDividerHeight = dividerHeight;
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    public void setDividerCondition(int dividerCondition) {
        this.mDividerCondition = dividerCondition;
    }

    public int getDividerCondition() {
        return this.mDividerCondition;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerCondition {
    }

    public static interface DividedViewHolder {
        public boolean isDividerAllowedAbove();

        public boolean isDividerAllowedBelow();
    }
}

