/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ListView;
import com.android.setupwizardlib.R;

public class StickyHeaderListView
extends ListView {
    private View mSticky;
    private View mStickyContainer;
    private int mStatusBarInset = 0;
    private RectF mStickyRect = new RectF();

    public StickyHeaderListView(Context context) {
        super(context);
        this.init(null, 16842868);
    }

    public StickyHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 16842868);
    }

    public StickyHeaderListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuwStickyHeaderListView, defStyleAttr, 0);
        int headerResId = a.getResourceId(R.styleable.SuwStickyHeaderListView_suwHeader, 0);
        if (headerResId != 0) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            View header = inflater.inflate(headerResId, (ViewGroup)this, false);
            this.addHeaderView(header, null, false);
        }
        a.recycle();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mSticky == null) {
            this.updateStickyView();
        }
    }

    public void updateStickyView() {
        this.mSticky = this.findViewWithTag("sticky");
        this.mStickyContainer = this.findViewWithTag("stickyContainer");
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mStickyRect.contains(ev.getX(), ev.getY())) {
            ev.offsetLocation(-this.mStickyRect.left, -this.mStickyRect.top);
            return this.mStickyContainer.dispatchTouchEvent(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mSticky != null) {
            int saveCount = canvas.save();
            View drawTarget = this.mStickyContainer != null ? this.mStickyContainer : this.mSticky;
            int drawOffset = this.mStickyContainer != null ? this.mSticky.getTop() : 0;
            int drawTop = drawTarget.getTop();
            if (drawTop + drawOffset < this.mStatusBarInset || !drawTarget.isShown()) {
                this.mStickyRect.set(0.0f, (float)(-drawOffset + this.mStatusBarInset), (float)drawTarget.getWidth(), (float)(drawTarget.getHeight() - drawOffset + this.mStatusBarInset));
                canvas.translate(0.0f, this.mStickyRect.top);
                canvas.clipRect(0, 0, drawTarget.getWidth(), drawTarget.getHeight());
                drawTarget.draw(canvas);
            } else {
                this.mStickyRect.setEmpty();
            }
            canvas.restoreToCount(saveCount);
        }
    }

    @TargetApi(value=21)
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        if (this.getFitsSystemWindows()) {
            this.mStatusBarInset = insets.getSystemWindowInsetTop();
            insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), 0, insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }
        return insets;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        int numberOfHeaders = this.mSticky != null ? 1 : 0;
        event.setItemCount(event.getItemCount() - numberOfHeaders);
        event.setFromIndex(Math.max(event.getFromIndex() - numberOfHeaders, 0));
        if (Build.VERSION.SDK_INT >= 14) {
            event.setToIndex(Math.max(event.getToIndex() - numberOfHeaders, 0));
        }
    }
}

