/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Animatable;
import android.media.MediaPlayer;
import android.support.annotation.RawRes;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.android.setupwizardlib.R;

@TargetApi(value=14)
public class IllustrationVideoView
extends TextureView
implements Animatable,
TextureView.SurfaceTextureListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnInfoListener {
    protected float mAspectRatio = 1.0f;
    protected MediaPlayer mMediaPlayer;
    @RawRes
    private int mVideoResId = 0;
    @VisibleForTesting
    Surface mSurface;

    public IllustrationVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwIllustrationVideoView);
        this.mVideoResId = a.getResourceId(R.styleable.SuwIllustrationVideoView_suwVideo, 0);
        a.recycle();
        this.setScaleX(0.9999999f);
        this.setScaleX(0.9999999f);
        this.setSurfaceTextureListener(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if ((float)height < (float)width * this.mAspectRatio) {
            width = (int)((float)height / this.mAspectRatio);
        } else {
            height = (int)((float)width * this.mAspectRatio);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public void setVideoResource(@RawRes int resId) {
        if (resId != this.mVideoResId) {
            this.mVideoResId = resId;
            this.createMediaPlayer();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.start();
        } else {
            this.stop();
        }
    }

    private void createMediaPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
        if (this.mSurface == null || this.mVideoResId == 0) {
            return;
        }
        this.mMediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)this.mVideoResId);
        this.mMediaPlayer.setSurface(this.mSurface);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
        this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        float aspectRatio = (float)this.mMediaPlayer.getVideoHeight() / (float)this.mMediaPlayer.getVideoWidth();
        if (this.mAspectRatio != aspectRatio) {
            this.mAspectRatio = aspectRatio;
            this.requestLayout();
        }
        if (this.getWindowVisibility() == 0) {
            this.start();
        }
    }

    protected boolean shouldLoop() {
        return true;
    }

    public void release() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        this.setVisibility(4);
        this.mSurface = new Surface(surfaceTexture);
        this.createMediaPlayer();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void start() {
        if (this.mMediaPlayer != null && !this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.start();
        }
    }

    public void stop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.pause();
        }
    }

    public boolean isRunning() {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying();
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        if (what == 3) {
            this.setVisibility(0);
        }
        return false;
    }

    public void onPrepared(MediaPlayer mp) {
        mp.setLooping(this.shouldLoop());
    }

    public void onSeekComplete(MediaPlayer mp) {
        mp.start();
    }

    public int getCurrentPosition() {
        return this.mMediaPlayer == null ? 0 : this.mMediaPlayer.getCurrentPosition();
    }
}

