/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.os.Build;
import android.view.View;

public class DrawableLayoutDirectionHelper {
    @SuppressLint(value={"InlinedApi"})
    public static InsetDrawable createRelativeInsetDrawable(Drawable drawable, int insetStart, int insetTop, int insetEnd, int insetBottom, View view) {
        boolean isRtl = Build.VERSION.SDK_INT >= 17 && view.getLayoutDirection() == 1;
        return DrawableLayoutDirectionHelper.createRelativeInsetDrawable(drawable, insetStart, insetTop, insetEnd, insetBottom, isRtl);
    }

    @SuppressLint(value={"InlinedApi"})
    public static InsetDrawable createRelativeInsetDrawable(Drawable drawable, int insetStart, int insetTop, int insetEnd, int insetBottom, Context context) {
        boolean isRtl = false;
        if (Build.VERSION.SDK_INT >= 17) {
            int layoutDirection = context.getResources().getConfiguration().getLayoutDirection();
            isRtl = layoutDirection == 1;
        }
        return DrawableLayoutDirectionHelper.createRelativeInsetDrawable(drawable, insetStart, insetTop, insetEnd, insetBottom, isRtl);
    }

    @SuppressLint(value={"InlinedApi"})
    public static InsetDrawable createRelativeInsetDrawable(Drawable drawable, int insetStart, int insetTop, int insetEnd, int insetBottom, int layoutDirection) {
        return DrawableLayoutDirectionHelper.createRelativeInsetDrawable(drawable, insetStart, insetTop, insetEnd, insetBottom, layoutDirection == 1);
    }

    private static InsetDrawable createRelativeInsetDrawable(Drawable drawable, int insetStart, int insetTop, int insetEnd, int insetBottom, boolean isRtl) {
        if (isRtl) {
            return new InsetDrawable(drawable, insetEnd, insetTop, insetStart, insetBottom);
        }
        return new InsetDrawable(drawable, insetStart, insetTop, insetEnd, insetBottom);
    }
}

