/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import com.android.setupwizardlib.template.RequireScrollMixin;

public class RecyclerViewScrollHandlingDelegate
implements RequireScrollMixin.ScrollHandlingDelegate {
    private static final String TAG = "RVRequireScrollMixin";
    @Nullable
    private final RecyclerView mRecyclerView;
    @NonNull
    private final RequireScrollMixin mRequireScrollMixin;

    public RecyclerViewScrollHandlingDelegate(@NonNull RequireScrollMixin requireScrollMixin, @Nullable RecyclerView recyclerView) {
        this.mRequireScrollMixin = requireScrollMixin;
        this.mRecyclerView = recyclerView;
    }

    private boolean canScrollDown() {
        if (this.mRecyclerView != null) {
            int offset = this.mRecyclerView.computeVerticalScrollOffset();
            int range = this.mRecyclerView.computeVerticalScrollRange() - this.mRecyclerView.computeVerticalScrollExtent();
            return range != 0 && offset < range - 1;
        }
        return false;
    }

    @Override
    public void startListening() {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    RecyclerViewScrollHandlingDelegate.this.mRequireScrollMixin.notifyScrollabilityChange(RecyclerViewScrollHandlingDelegate.this.canScrollDown());
                }
            });
            if (this.canScrollDown()) {
                this.mRequireScrollMixin.notifyScrollabilityChange(true);
            }
        } else {
            Log.w((String)TAG, (String)"Cannot require scroll. Recycler view is null.");
        }
    }

    @Override
    public void pageScrollDown() {
        if (this.mRecyclerView != null) {
            int height = this.mRecyclerView.getHeight();
            this.mRecyclerView.smoothScrollBy(0, height);
        }
    }
}

