/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.InflateException;
import com.android.setupwizardlib.items.SimpleInflater;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public abstract class ReflectionInflater<T>
extends SimpleInflater<T> {
    private static final Class<?>[] CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap<String, Constructor<?>> sConstructorMap = new HashMap();
    private final Object[] mTempConstructorArgs = new Object[2];
    @Nullable
    private String mDefaultPackage;
    @NonNull
    private final Context mContext;

    protected ReflectionInflater(@NonNull Context context) {
        super(context.getResources());
        this.mContext = context;
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    public final T createItem(String tagName, String prefix, AttributeSet attrs) {
        String qualifiedName = tagName;
        if (prefix != null && qualifiedName.indexOf(46) == -1) {
            qualifiedName = prefix.concat(qualifiedName);
        }
        Constructor<?> constructor = sConstructorMap.get(qualifiedName);
        try {
            if (constructor == null) {
                Class<?> clazz = this.mContext.getClassLoader().loadClass(qualifiedName);
                constructor = clazz.getConstructor(CONSTRUCTOR_SIGNATURE);
                constructor.setAccessible(true);
                sConstructorMap.put(tagName, constructor);
            }
            this.mTempConstructorArgs[0] = this.mContext;
            this.mTempConstructorArgs[1] = attrs;
            Object item = constructor.newInstance(this.mTempConstructorArgs);
            this.mTempConstructorArgs[0] = null;
            this.mTempConstructorArgs[1] = null;
            return (T)item;
        }
        catch (Exception e) {
            throw new InflateException(attrs.getPositionDescription() + ": Error inflating class " + qualifiedName, (Throwable)e);
        }
    }

    @Override
    protected T onCreateItem(String tagName, AttributeSet attrs) {
        return this.createItem(tagName, this.mDefaultPackage, attrs);
    }

    public void setDefaultPackage(@Nullable String defaultPackage) {
        this.mDefaultPackage = defaultPackage;
    }

    @Nullable
    public String getDefaultPackage() {
        return this.mDefaultPackage;
    }
}

