/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.lang.ref.SoftReference;

public class GlifPatternDrawable
extends Drawable {
    @SuppressLint(value={"InlinedApi"})
    private static final int[] ATTRS_PRIMARY_COLOR = new int[]{16843827};
    private static final float VIEWBOX_HEIGHT = 768.0f;
    private static final float VIEWBOX_WIDTH = 1366.0f;
    private static final float SCALE_FOCUS_X = 0.146f;
    private static final float SCALE_FOCUS_Y = 0.228f;
    private static final float COLOR_ALPHA = 0.8f;
    private static final int COLOR_ALPHA_INT = 204;
    private static final float MAX_CACHED_BITMAP_SCALE = 1.5f;
    private static final int NUM_PATHS = 7;
    private static SoftReference<Bitmap> sBitmapCache;
    private static Path[] sPatternPaths;
    private static int[] sPatternLightness;
    private int mColor;
    private Paint mTempPaint = new Paint(1);
    private ColorFilter mColorFilter;

    public static GlifPatternDrawable getDefault(Context context) {
        int colorPrimary = 0;
        if (Build.VERSION.SDK_INT >= 21) {
            TypedArray a = context.obtainStyledAttributes(ATTRS_PRIMARY_COLOR);
            colorPrimary = a.getColor(0, -16777216);
            a.recycle();
        }
        return new GlifPatternDrawable(colorPrimary);
    }

    @VisibleForTesting
    public static void invalidatePattern() {
        sBitmapCache = null;
    }

    public GlifPatternDrawable(int color) {
        this.setColor(color);
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        int drawableWidth = bounds.width();
        int drawableHeight = bounds.height();
        Bitmap bitmap = null;
        if (sBitmapCache != null) {
            bitmap = sBitmapCache.get();
        }
        if (bitmap != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            if (drawableWidth > bitmapWidth && (float)bitmapWidth < 2049.0f) {
                bitmap = null;
            } else if (drawableHeight > bitmapHeight && (float)bitmapHeight < 1152.0f) {
                bitmap = null;
            }
        }
        if (bitmap == null) {
            this.mTempPaint.reset();
            bitmap = this.createBitmapCache(drawableWidth, drawableHeight);
            sBitmapCache = new SoftReference<Bitmap>(bitmap);
            this.mTempPaint.reset();
        }
        canvas.save();
        canvas.clipRect(bounds);
        this.scaleCanvasToBounds(canvas, bitmap, bounds);
        if (Build.VERSION.SDK_INT >= 11 && canvas.isHardwareAccelerated()) {
            this.mTempPaint.setColorFilter(this.mColorFilter);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mTempPaint);
        } else {
            canvas.drawColor(-16777216);
            this.mTempPaint.setColor(-1);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mTempPaint);
            canvas.drawColor(this.mColor);
        }
        canvas.restore();
    }

    @VisibleForTesting
    public Bitmap createBitmapCache(int drawableWidth, int drawableHeight) {
        float scaleX = (float)drawableWidth / 1366.0f;
        float scaleY = (float)drawableHeight / 768.0f;
        float scale = Math.max(scaleX, scaleY);
        scale = Math.min(1.5f, scale);
        int scaledWidth = (int)(1366.0f * scale);
        int scaledHeight = (int)(768.0f * scale);
        Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        Canvas bitmapCanvas = new Canvas(bitmap);
        this.renderOnCanvas(bitmapCanvas, scale);
        return bitmap;
    }

    private void renderOnCanvas(Canvas canvas, float scale) {
        canvas.save();
        canvas.scale(scale, scale);
        this.mTempPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        if (sPatternPaths == null) {
            sPatternPaths = new Path[7];
            sPatternLightness = new int[]{10, 40, 51, 66, 91, 112, 130};
            Path p = GlifPatternDrawable.sPatternPaths[0] = new Path();
            p.moveTo(1029.4f, 357.5f);
            p.lineTo(1366.0f, 759.1f);
            p.lineTo(1366.0f, 0.0f);
            p.lineTo(1137.7f, 0.0f);
            p.close();
            p = GlifPatternDrawable.sPatternPaths[1] = new Path();
            p.moveTo(1138.1f, 0.0f);
            p.rLineTo(-144.8f, 768.0f);
            p.rLineTo(372.7f, 0.0f);
            p.rLineTo(0.0f, -524.0f);
            p.cubicTo(1290.7f, 121.6f, 1219.2f, 41.1f, 1178.7f, 0.0f);
            p.close();
            p = GlifPatternDrawable.sPatternPaths[2] = new Path();
            p.moveTo(949.8f, 768.0f);
            p.rCubicTo(92.6f, -170.6f, 213.0f, -440.3f, 269.4f, -768.0f);
            p.lineTo(585.0f, 0.0f);
            p.rLineTo(2.1f, 766.0f);
            p.close();
            p = GlifPatternDrawable.sPatternPaths[3] = new Path();
            p.moveTo(471.1f, 768.0f);
            p.rMoveTo(704.5f, 0.0f);
            p.cubicTo(1123.6f, 563.3f, 1027.4f, 275.2f, 856.2f, 0.0f);
            p.lineTo(476.4f, 0.0f);
            p.rLineTo(-5.3f, 768.0f);
            p.close();
            p = GlifPatternDrawable.sPatternPaths[4] = new Path();
            p.moveTo(323.1f, 768.0f);
            p.moveTo(777.5f, 768.0f);
            p.cubicTo(661.9f, 348.8f, 427.2f, 21.4f, 401.2f, 25.4f);
            p.lineTo(323.1f, 768.0f);
            p.close();
            p = GlifPatternDrawable.sPatternPaths[5] = new Path();
            p.moveTo(178.44286f, 766.8571f);
            p.lineTo(308.7f, 768.0f);
            p.cubicTo(381.7f, 604.6f, 481.6f, 344.3f, 562.2f, 0.0f);
            p.lineTo(0.0f, 0.0f);
            p.close();
            p = GlifPatternDrawable.sPatternPaths[6] = new Path();
            p.moveTo(146.0f, 0.0f);
            p.lineTo(0.0f, 0.0f);
            p.lineTo(0.0f, 768.0f);
            p.lineTo(394.2f, 768.0f);
            p.cubicTo(327.7f, 475.3f, 228.5f, 201.0f, 146.0f, 0.0f);
            p.close();
        }
        for (int i = 0; i < 7; ++i) {
            this.mTempPaint.setColor(sPatternLightness[i] << 24);
            canvas.drawPath(sPatternPaths[i], this.mTempPaint);
        }
        canvas.restore();
        this.mTempPaint.reset();
    }

    @VisibleForTesting
    public void scaleCanvasToBounds(Canvas canvas, Bitmap bitmap, Rect drawableBounds) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        float scaleX = (float)drawableBounds.width() / (float)bitmapWidth;
        float scaleY = (float)drawableBounds.height() / (float)bitmapHeight;
        canvas.scale(scaleX, scaleY);
        if (scaleY > scaleX) {
            canvas.scale(scaleY / scaleX, 1.0f, 0.146f * (float)bitmapWidth, 0.0f);
        } else if (scaleX > scaleY) {
            canvas.scale(1.0f, scaleX / scaleY, 0.0f, 0.228f * (float)bitmapHeight);
        }
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    public void setColor(int color) {
        int r = Color.red((int)color);
        int g = Color.green((int)color);
        int b = Color.blue((int)color);
        this.mColor = Color.argb((int)204, (int)r, (int)g, (int)b);
        this.mColorFilter = new ColorMatrixColorFilter(new float[]{0.0f, 0.0f, 0.0f, 0.19999999f, (float)r * 0.8f, 0.0f, 0.0f, 0.0f, 0.19999999f, (float)g * 0.8f, 0.0f, 0.0f, 0.0f, 0.19999999f, (float)b * 0.8f, 0.0f, 0.0f, 0.0f, 0.0f, 255.0f});
        this.invalidateSelf();
    }

    public int getColor() {
        return Color.argb((int)255, (int)Color.red((int)this.mColor), (int)Color.green((int)this.mColor), (int)Color.blue((int)this.mColor));
    }
}

