/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import com.android.setupwizardlib.GlifPatternDrawable;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.ButtonFooterMixin;
import com.android.setupwizardlib.template.ColoredHeaderMixin;
import com.android.setupwizardlib.template.HeaderMixin;
import com.android.setupwizardlib.template.IconMixin;
import com.android.setupwizardlib.template.ProgressBarMixin;
import com.android.setupwizardlib.template.RequireScrollMixin;
import com.android.setupwizardlib.template.ScrollViewScrollHandlingDelegate;
import com.android.setupwizardlib.view.StatusBarBackgroundLayout;

public class GlifLayout
extends TemplateLayout {
    private static final String TAG = "GlifLayout";
    private ColorStateList mPrimaryColor;
    private boolean mBackgroundPatterned = true;
    @Nullable
    private ColorStateList mBackgroundBaseColor;

    public GlifLayout(Context context) {
        this(context, 0, 0);
    }

    public GlifLayout(Context context, int template) {
        this(context, template, 0);
    }

    public GlifLayout(Context context, int template, int containerId) {
        super(context, template, containerId);
        this.init(null, R.attr.suwLayoutTheme);
    }

    public GlifLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, R.attr.suwLayoutTheme);
    }

    @TargetApi(value=11)
    public GlifLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a;
        ColorStateList primaryColor;
        this.registerMixin(HeaderMixin.class, new ColoredHeaderMixin(this, attrs, defStyleAttr));
        this.registerMixin(IconMixin.class, new IconMixin(this, attrs, defStyleAttr));
        this.registerMixin(ProgressBarMixin.class, new ProgressBarMixin(this));
        this.registerMixin(ButtonFooterMixin.class, new ButtonFooterMixin(this));
        RequireScrollMixin requireScrollMixin = new RequireScrollMixin(this);
        this.registerMixin(RequireScrollMixin.class, requireScrollMixin);
        ScrollView scrollView = this.getScrollView();
        if (scrollView != null) {
            requireScrollMixin.setScrollHandlingDelegate(new ScrollViewScrollHandlingDelegate(requireScrollMixin, scrollView));
        }
        if ((primaryColor = (a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuwGlifLayout, defStyleAttr, 0)).getColorStateList(R.styleable.SuwGlifLayout_suwColorPrimary)) != null) {
            this.setPrimaryColor(primaryColor);
        }
        ColorStateList backgroundColor = a.getColorStateList(R.styleable.SuwGlifLayout_suwBackgroundBaseColor);
        this.setBackgroundBaseColor(backgroundColor);
        boolean backgroundPatterned = a.getBoolean(R.styleable.SuwGlifLayout_suwBackgroundPatterned, true);
        this.setBackgroundPatterned(backgroundPatterned);
        int footer = a.getResourceId(R.styleable.SuwGlifLayout_suwFooter, 0);
        if (footer != 0) {
            this.inflateFooter(footer);
        }
        a.recycle();
    }

    @Override
    protected View onInflateTemplate(LayoutInflater inflater, @LayoutRes int template) {
        if (template == 0) {
            template = R.layout.suw_glif_template;
        }
        return this.inflateTemplate(inflater, R.style.SuwThemeGlif_Light, template);
    }

    @Override
    protected ViewGroup findContainer(int containerId) {
        if (containerId == 0) {
            containerId = R.id.suw_layout_content;
        }
        return super.findContainer(containerId);
    }

    public View inflateFooter(@LayoutRes int footer) {
        ViewStub footerStub = (ViewStub)this.findManagedViewById(R.id.suw_layout_footer);
        footerStub.setLayoutResource(footer);
        return footerStub.inflate();
    }

    public ScrollView getScrollView() {
        View view = this.findManagedViewById(R.id.suw_scroll_view);
        return view instanceof ScrollView ? (ScrollView)view : null;
    }

    public TextView getHeaderTextView() {
        return this.getMixin(HeaderMixin.class).getTextView();
    }

    public void setHeaderText(int title) {
        this.getMixin(HeaderMixin.class).setText(title);
    }

    public void setHeaderText(CharSequence title) {
        this.getMixin(HeaderMixin.class).setText(title);
    }

    public CharSequence getHeaderText() {
        return this.getMixin(HeaderMixin.class).getText();
    }

    public void setHeaderColor(ColorStateList color) {
        ColoredHeaderMixin mixin = (ColoredHeaderMixin)this.getMixin(HeaderMixin.class);
        mixin.setColor(color);
    }

    public ColorStateList getHeaderColor() {
        ColoredHeaderMixin mixin = (ColoredHeaderMixin)this.getMixin(HeaderMixin.class);
        return mixin.getColor();
    }

    public void setIcon(Drawable icon) {
        this.getMixin(IconMixin.class).setIcon(icon);
    }

    public Drawable getIcon() {
        return this.getMixin(IconMixin.class).getIcon();
    }

    public void setPrimaryColor(@NonNull ColorStateList color) {
        this.mPrimaryColor = color;
        this.updateBackground();
        this.getMixin(ProgressBarMixin.class).setColor(color);
    }

    public ColorStateList getPrimaryColor() {
        return this.mPrimaryColor;
    }

    public void setBackgroundBaseColor(@Nullable ColorStateList color) {
        this.mBackgroundBaseColor = color;
        this.updateBackground();
    }

    @Nullable
    public ColorStateList getBackgroundBaseColor() {
        return this.mBackgroundBaseColor;
    }

    public void setBackgroundPatterned(boolean patterned) {
        this.mBackgroundPatterned = patterned;
        this.updateBackground();
    }

    public boolean isBackgroundPatterned() {
        return this.mBackgroundPatterned;
    }

    private void updateBackground() {
        View patternBg = this.findManagedViewById(R.id.suw_pattern_bg);
        if (patternBg != null) {
            GlifPatternDrawable background;
            int backgroundColor = 0;
            if (this.mBackgroundBaseColor != null) {
                backgroundColor = this.mBackgroundBaseColor.getDefaultColor();
            } else if (this.mPrimaryColor != null) {
                backgroundColor = this.mPrimaryColor.getDefaultColor();
            }
            GlifPatternDrawable glifPatternDrawable = background = this.mBackgroundPatterned ? new GlifPatternDrawable(backgroundColor) : new ColorDrawable(backgroundColor);
            if (patternBg instanceof StatusBarBackgroundLayout) {
                ((StatusBarBackgroundLayout)patternBg).setStatusBarBackground(background);
            } else {
                patternBg.setBackgroundDrawable((Drawable)background);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.setSystemUiVisibility(1024);
        }
    }

    public boolean isProgressBarShown() {
        return this.getMixin(ProgressBarMixin.class).isShown();
    }

    public void setProgressBarShown(boolean shown) {
        this.getMixin(ProgressBarMixin.class).setShown(shown);
    }

    public ProgressBar peekProgressBar() {
        return this.getMixin(ProgressBarMixin.class).peekProgressBar();
    }
}

