/*
 * Decompiled with CFR 0.152.
 */
package me.leejay.jenkins.dateparameter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerParamMethod {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern PATTERN = Pattern.compile("^(?<name>.+)\\((?<parameter>[0-9]+)\\);?$");
    public String name;
    public Integer parameter;
    private String code;

    public IntegerParamMethod(String code) {
        this.log.info("IntegerParamMethod({})", (Object)code);
        this.code = code;
        this.parse();
    }

    private void parse() {
        Matcher matcher = PATTERN.matcher(this.code);
        if (matcher.matches()) {
            this.name = matcher.group("name");
            this.parameter = Integer.parseInt(matcher.group("parameter"));
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getParameter() {
        return this.parameter;
    }
}

