/*
 * Decompiled with CFR 0.152.
 */
package me.leejay.jenkins.dateparameter;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import me.leejay.jenkins.dateparameter.DateParameterValue;
import me.leejay.jenkins.dateparameter.StringLocalDateValue;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateParameterDefinition
extends ParameterDefinition {
    private static final Logger log = LoggerFactory.getLogger(DateParameterDefinition.class);
    private static final long serialVersionUID = 776445397055325795L;
    private final StringLocalDateValue stringLocalDateValue;

    @DataBoundConstructor
    public DateParameterDefinition(String name, String dateFormat, String defaultValue, String description) {
        super(name, description);
        this.stringLocalDateValue = new StringLocalDateValue(defaultValue, dateFormat);
    }

    public String getName() {
        return super.getName();
    }

    public String getDescription() {
        return super.getDescription();
    }

    public String getDateFormat() {
        return this.stringLocalDateValue.getStringDateFormat();
    }

    public String getDefaultValue() {
        return this.stringLocalDateValue.getStringLocalDate();
    }

    public String getValue() {
        return this.stringLocalDateValue.getValue();
    }

    public DateParameterValue getDefaultParameterValue() {
        DateParameterValue value = new DateParameterValue(this.getName(), this.getValue(), this.getDescription());
        value.createValueFromDefault(this.getDateFormat());
        return value;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        DateParameterValue value = (DateParameterValue)((Object)req.bindJSON(DateParameterValue.class, jo));
        value.createValueFromJenkins(this.getDateFormat());
        return value;
    }

    public ParameterValue createValue(StaplerRequest staplerRequest) {
        String requestedValue = staplerRequest.getParameter(this.getName());
        if (StringUtils.isEmpty((String)requestedValue)) {
            return this.getDefaultParameterValue();
        }
        DateParameterValue value = new DateParameterValue(this.getName(), requestedValue, this.getDateFormat(), this.getDescription());
        value.createValueFromPostRequest(this.getDateFormat());
        return value;
    }

    @Extension
    public static final class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private static final String DISPLAY_NAME = "Date Parameter";

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (StringUtils.isEmpty((String)name)) {
                return FormValidation.error((String)"Please enter a name.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDateFormat(@QueryParameter String dateFormat) {
            if (StringUtils.isEmpty((String)dateFormat)) {
                return FormValidation.error((String)"Please enter a date format");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDefaultValue(@QueryParameter String dateFormat, @QueryParameter String defaultValue) {
            StringLocalDateValue value = new StringLocalDateValue(defaultValue, dateFormat);
            if (value.isCompletionFormat()) {
                return FormValidation.ok();
            }
            if (value.isJavaFormat()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid default value");
        }
    }
}

