/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;
import me.ledge.link.api.vos.datapoints.DataPointVo;

public class Income
extends DataPointVo {
    public double monthlyNetIncome;
    public long annualGrossIncome;

    public Income() {
        this(-1.0, -1L, false, false);
    }

    public Income(double monthlyNetIncome, long annualGrossIncome, boolean verified, boolean notSpecified) {
        super(DataPointVo.DataPointType.Income, verified, notSpecified);
        this.monthlyNetIncome = monthlyNetIncome;
        this.annualGrossIncome = annualGrossIncome;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject gsonObject = super.toJSON();
        gsonObject.addProperty("data_type", "income");
        gsonObject.addProperty("gross_annual_income", (Number)this.annualGrossIncome);
        gsonObject.addProperty("net_monthly_income", (Number)this.monthlyNetIncome);
        return gsonObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Income income = (Income)o;
        if (Double.compare(income.monthlyNetIncome, this.monthlyNetIncome) != 0) {
            return false;
        }
        return this.annualGrossIncome == income.annualGrossIncome;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.monthlyNetIncome);
        result += (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.annualGrossIncome ^ this.annualGrossIncome >>> 32);
        return result;
    }
}

