/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import me.ledge.link.api.vos.datapoints.VerificationVo;

public class DataPointVo {
    @SerializedName(value="type")
    private final DataPointType mDataPointType;
    @SerializedName(value="verified")
    private boolean mVerified;
    private VerificationVo mVerification;
    private boolean mNotSpecified;

    public DataPointVo() {
        this(null, false, false);
    }

    public DataPointVo(DataPointType type, boolean verified, boolean notSpecified) {
        this.mDataPointType = type;
        this.mVerified = verified;
        this.mNotSpecified = notSpecified;
    }

    public DataPointVo(DataPointVo copy) {
        this.mDataPointType = copy.getType();
        this.mVerified = copy.isVerified();
        this.mVerification = copy.getVerification();
        this.mNotSpecified = copy.isNotSpecified();
    }

    public void invalidateVerification() {
        this.mVerification = null;
        this.mVerified = false;
    }

    public DataPointType getType() {
        return this.mDataPointType;
    }

    public boolean isNotSpecified() {
        return this.mNotSpecified;
    }

    public void setNotSpecified(boolean notSpecified) {
        this.mNotSpecified = notSpecified;
    }

    public boolean isVerified() {
        return this.mVerified || this.hasVerification() && this.getVerification().isVerified();
    }

    public boolean hasVerification() {
        return this.mVerification != null;
    }

    public VerificationVo getVerification() {
        return this.mVerification;
    }

    public void setVerification(VerificationVo verification) {
        this.mVerification = verification;
    }

    public JsonObject toJSON() {
        JsonObject gsonObject = new JsonObject();
        if (this.hasVerification()) {
            gsonObject.add("verification", (JsonElement)this.mVerification.toJSON());
        }
        gsonObject.addProperty("not_specified", Boolean.valueOf(this.mNotSpecified));
        return gsonObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPointVo that = (DataPointVo)o;
        if (this.mVerified != that.mVerified) {
            return false;
        }
        if (this.mNotSpecified != that.mNotSpecified) {
            return false;
        }
        if (this.mDataPointType != that.mDataPointType) {
            return false;
        }
        return this.mVerification != null ? this.mVerification.equals(that.mVerification) : that.mVerification == null;
    }

    public int hashCode() {
        int result = this.mDataPointType != null ? this.mDataPointType.hashCode() : 0;
        result = 31 * result + (this.mVerified ? 1 : 0);
        result = 31 * result + (this.mVerification != null ? this.mVerification.hashCode() : 0);
        result = 31 * result + (this.mNotSpecified ? 1 : 0);
        return result;
    }

    public static enum DataPointType {
        PersonalName("NAME"),
        Phone("PHONE"),
        Email("EMAIL"),
        BirthDate("BIRTHDATE"),
        SSN("SSN"),
        Address("ADDRESS"),
        Housing("HOUSING"),
        IncomeSource("INCOME_SOURCE"),
        Income("INCOME"),
        CreditScore("CREDIT_SCORE"),
        FinancialAccount("FINANCIAL_ACCOUNT"),
        PayDayLoan("PAYDAY_LOAN"),
        MemberOfArmedForces("MEMBER_OF_ARMED_FORCES"),
        TimeAtAddress("TIME_AT_ADDRESS");

        private String type;

        private DataPointType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static DataPointType fromString(String type) {
            for (DataPointType enumType : DataPointType.values()) {
                if (!enumType.type.equalsIgnoreCase(type)) continue;
                return enumType;
            }
            return null;
        }
    }
}

