/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.server.http.server;

import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.UsbFileInputStream;
import com.github.mjdev.libaums.server.http.UsbFileProvider;
import com.github.mjdev.libaums.server.http.exception.NotAFileException;
import com.github.mjdev.libaums.server.http.server.HttpServer;
import fi.iki.elonen.NanoHTTPD;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/github/mjdev/libaums/server/http/server/NanoHttpdServer;", "Lcom/github/mjdev/libaums/server/http/server/HttpServer;", "port", "", "(I)V", "hostname", "", "(Ljava/lang/String;I)V", "getHostname", "()Ljava/lang/String;", "httpServer", "Lcom/github/mjdev/libaums/server/http/server/NanoHttpdServer$NHttpServer;", "isAlive", "", "()Z", "listeningPort", "getListeningPort", "()I", "usbFileProvider", "Lcom/github/mjdev/libaums/server/http/UsbFileProvider;", "getUsbFileProvider", "()Lcom/github/mjdev/libaums/server/http/UsbFileProvider;", "setUsbFileProvider", "(Lcom/github/mjdev/libaums/server/http/UsbFileProvider;)V", "start", "", "stop", "Companion", "NHttpServer", "libaums-httpserver_release"})
public final class NanoHttpdServer
implements HttpServer {
    @NotNull
    public UsbFileProvider usbFileProvider;
    private NHttpServer httpServer;
    private static final String TAG;
    public static final Companion Companion;

    @Override
    public boolean isAlive() {
        return this.httpServer.isAlive();
    }

    @Override
    @NotNull
    public String getHostname() {
        String string = this.httpServer.getHostname();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"httpServer.hostname");
        return string;
    }

    @Override
    public int getListeningPort() {
        return this.httpServer.getListeningPort();
    }

    @Override
    @NotNull
    public UsbFileProvider getUsbFileProvider() {
        UsbFileProvider usbFileProvider = this.usbFileProvider;
        if (usbFileProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbFileProvider");
        }
        return usbFileProvider;
    }

    @Override
    public void setUsbFileProvider(@NotNull UsbFileProvider usbFileProvider) {
        Intrinsics.checkParameterIsNotNull((Object)usbFileProvider, (String)"<set-?>");
        this.usbFileProvider = usbFileProvider;
    }

    @Override
    public void start() {
        this.httpServer.start();
    }

    @Override
    public void stop() {
        this.httpServer.stop();
    }

    public NanoHttpdServer(int port) {
        this.httpServer = new NHttpServer(port);
    }

    public NanoHttpdServer(@NotNull String hostname, int port) {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        this.httpServer = new NHttpServer(hostname, port);
    }

    static {
        Companion = new Companion(null);
        String string = NanoHttpdServer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NanoHttpdServer::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/github/mjdev/libaums/server/http/server/NanoHttpdServer$NHttpServer;", "Lfi/iki/elonen/NanoHTTPD;", "port", "", "(Lcom/github/mjdev/libaums/server/http/server/NanoHttpdServer;I)V", "hostname", "", "(Lcom/github/mjdev/libaums/server/http/server/NanoHttpdServer;Ljava/lang/String;I)V", "createInputStream", "Ljava/io/InputStream;", "file", "Lcom/github/mjdev/libaums/fs/UsbFile;", "serve", "Lfi/iki/elonen/NanoHTTPD$Response;", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "serveCompleteFile", "serveRangeOfFile", "range", "libaums-httpserver_release"})
    private final class NHttpServer
    extends NanoHTTPD {
        @NotNull
        public NanoHTTPD.Response serve(@NotNull NanoHTTPD.IHTTPSession session) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            String uri = null;
            try {
                String string = URLDecoder.decode(session.getUri(), "Unicode");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLDecoder.decode(session.uri, \"Unicode\")");
                uri = string;
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"could not decode URL", (Throwable)e);
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"text/html", (String)"Unable to decode URL");
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newFixedLengthResponse(R\u2026, \"Unable to decode URL\")");
                return response;
            }
            Log.d((String)TAG, (String)("Request: " + uri));
            Map headers = session.getHeaders();
            String range = (String)headers.get("range");
            try {
                String string;
                block9: {
                    UsbFile fileToServe;
                    block8: {
                        fileToServe = NanoHttpdServer.this.getUsbFileProvider().determineFileToServe(uri);
                        string = range;
                        if (string == null) break block8;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        string = this.serveRangeOfFile(fileToServe, it);
                        if (string != null) break block9;
                    }
                    string = this.serveCompleteFile(fileToServe);
                }
                object = string;
            }
            catch (FileNotFoundException e) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/html", (String)e.getMessage());
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newFixedLengthResponse(R\u2026    MIME_HTML, e.message)");
                object = response;
            }
            catch (NotAFileException e) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"text/html", (String)e.getMessage());
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newFixedLengthResponse(R\u2026    MIME_HTML, e.message)");
                object = response;
            }
            catch (IOException e) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR), (String)"text/html", (String)e.getMessage());
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newFixedLengthResponse(R\u2026    MIME_HTML, e.message)");
                object = response;
            }
            return object;
        }

        private final NanoHTTPD.Response serveCompleteFile(UsbFile file) {
            Log.d((String)TAG, (String)"Serving complete file");
            String mimeType = NanoHTTPD.getMimeTypeForFile((String)file.getName());
            NanoHTTPD.Response res = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK), (String)mimeType, (InputStream)this.createInputStream(file), (long)file.getLength());
            res.addHeader("Accept-Ranges", "bytes");
            NanoHTTPD.Response response = res;
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"res");
            return response;
        }

        private final NanoHTTPD.Response serveRangeOfFile(UsbFile file, String range) throws IOException {
            long contentLength;
            String newRange = range;
            Log.d((String)TAG, (String)("Serving range of file " + newRange));
            String mimeType = NanoHTTPD.getMimeTypeForFile((String)file.getName());
            long start = 0L;
            long end = -1L;
            long length = file.getLength();
            if (StringsKt.startsWith$default((String)newRange, (String)"bytes=", (boolean)false, (int)2, null)) {
                String string = newRange;
                int n = "bytes=".length();
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                newRange = string3;
                int minus = StringsKt.indexOf$default((CharSequence)newRange, (char)'-', (int)0, (boolean)false, (int)6, null);
                try {
                    if (minus > 0) {
                        String string4 = newRange;
                        n2 = 0;
                        boolean bl = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(n2, minus);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        start = Long.parseLong(string6);
                        string4 = newRange;
                        n2 = minus + 1;
                        bl = false;
                        String string7 = string4;
                        if (string7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string8 = string7.substring(n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                        end = Long.parseLong(string8);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"text/html", (String)"Range header invalid");
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newFixedLengthResponse(R\u2026, \"Range header invalid\")");
                return response;
            }
            if (start < 0L || end >= length) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE), (String)"text/html", (String)"Start < 0 or end >= actual length");
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newFixedLengthResponse(R\u2026or end >= actual length\")");
                return response;
            }
            if (end < 0L) {
                end = length - 1L;
            }
            if ((contentLength = end - start + 1L) < 0L) {
                contentLength = 0L;
            }
            Log.d((String)TAG, (String)("Serving file from " + start + " to " + end + ", Content-Length: " + contentLength));
            InputStream stream = this.createInputStream(file);
            stream.skip(start);
            NanoHTTPD.Response res = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.PARTIAL_CONTENT), (String)mimeType, (InputStream)stream, (long)contentLength);
            res.addHeader("Accept-Ranges", "bytes");
            res.addHeader("Content-Length", "" + contentLength);
            res.addHeader("Content-Range", "bytes " + start + '-' + end + '/' + length);
            NanoHTTPD.Response response = res;
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"res");
            return response;
        }

        private final InputStream createInputStream(UsbFile file) {
            return (InputStream)new UsbFileInputStream(file);
        }

        public NHttpServer(int port) {
            super(port);
        }

        public NHttpServer(String hostname, int port) {
            Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
            super(hostname, port);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/server/http/server/NanoHttpdServer$Companion;", "", "()V", "TAG", "", "libaums-httpserver_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

